/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.placeholder;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.placeholder.RegistrablePlaceholder;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.PatternUtils;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;

public final class PlayerPlaceholder
implements RegistrablePlaceholder {
    private final Pattern pattern;
    private final Function<@NotNull Player, @Nullable String> function;
    private final EcoPlugin plugin;

    public PlayerPlaceholder(@NotNull EcoPlugin plugin, @NotNull String identifier, @NotNull @NotNull Function<@NotNull Player, @Nullable String> function) {
        this.plugin = plugin;
        this.pattern = PatternUtils.compileLiteral(identifier);
        this.function = function;
    }

    @Override
    @Nullable
    public String getValue(@NotNull String args2, @NotNull PlaceholderContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return null;
        }
        return this.function.apply(player);
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    @NotNull
    public String getValue(@NotNull Player player) {
        return Objects.requireNonNullElse(this.function.apply(player), "");
    }

    @Override
    @NotNull
    public EcoPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    @NotNull
    public PlayerPlaceholder register() {
        return (PlayerPlaceholder)RegistrablePlaceholder.super.register();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerPlaceholder)) {
            return false;
        }
        PlayerPlaceholder that = (PlayerPlaceholder)o;
        return Objects.equals(this.getPattern(), that.getPattern()) && Objects.equals(this.getPlugin(), that.getPlugin());
    }

    public int hashCode() {
        return Objects.hash(this.getPattern(), this.getPlugin());
    }
}

