/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.placeholder.context;

import com.willfp.eco.core.placeholder.InjectablePlaceholder;
import com.willfp.eco.core.placeholder.PlaceholderInjectable;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MergedInjectableContext
implements PlaceholderInjectable {
    private final PlaceholderInjectable baseContext;
    private final PlaceholderInjectable additionalContext;
    private final Set<InjectablePlaceholder> extraInjections = new HashSet<InjectablePlaceholder>();

    public MergedInjectableContext(@NotNull PlaceholderInjectable baseContext, @NotNull PlaceholderInjectable additionalContext) {
        this.baseContext = baseContext;
        this.additionalContext = additionalContext;
    }

    @Override
    public void addInjectablePlaceholder(@NotNull Iterable<InjectablePlaceholder> placeholders) {
        for (InjectablePlaceholder placeholder2 : placeholders) {
            this.extraInjections.add(placeholder2);
        }
    }

    @Override
    public void clearInjectedPlaceholders() {
        this.baseContext.clearInjectedPlaceholders();
        this.additionalContext.clearInjectedPlaceholders();
        this.extraInjections.clear();
    }

    @Override
    @NotNull
    public List<InjectablePlaceholder> getPlaceholderInjections() {
        List<InjectablePlaceholder> base = this.baseContext.getPlaceholderInjections();
        List<InjectablePlaceholder> additional = this.additionalContext.getPlaceholderInjections();
        ArrayList<InjectablePlaceholder> injections = new ArrayList<InjectablePlaceholder>(base.size() + additional.size() + this.extraInjections.size());
        injections.addAll(base);
        injections.addAll(additional);
        injections.addAll(this.extraInjections);
        return injections;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MergedInjectableContext)) {
            return false;
        }
        MergedInjectableContext that = (MergedInjectableContext)o;
        return Objects.equals(this.baseContext, that.baseContext) && Objects.equals(this.additionalContext, that.additionalContext) && Objects.equals(this.extraInjections, that.extraInjections);
    }

    public int hashCode() {
        return Objects.hash(this.baseContext, this.additionalContext, this.extraInjections);
    }
}

