/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.placeholder.templates;

import com.willfp.eco.core.placeholder.InjectablePlaceholder;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.PatternUtils;
import java.util.Objects;
import java.util.regex.Pattern;

public abstract class SimpleInjectablePlaceholder
implements InjectablePlaceholder {
    private final String identifier;
    private final Pattern pattern;

    protected SimpleInjectablePlaceholder(@NotNull String identifier) {
        this.identifier = identifier;
        this.pattern = PatternUtils.compileLiteral(identifier);
    }

    @Override
    public String tryTranslateQuickly(@NotNull String text, @NotNull PlaceholderContext context) {
        return text.replace("%" + this.identifier + "%", Objects.requireNonNullElse(this.getValue(this.identifier, context), ""));
    }

    @Override
    @NotNull
    public Pattern getPattern() {
        return this.pattern;
    }

    public String toString() {
        return "SimpleInjectablePlaceholder{identifier='" + this.identifier + "'}";
    }

    public boolean equals(@NotNull Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleInjectablePlaceholder)) {
            return false;
        }
        SimpleInjectablePlaceholder that = (SimpleInjectablePlaceholder)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }
}

