/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.price;

import com.willfp.eco.core.price.ConfiguredPrice;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public final class CombinedDisplayPrice {
    private final Map<ConfiguredPrice, Double> prices;
    private final Player player;

    private CombinedDisplayPrice(@NotNull Player player, @NotNull Map<ConfiguredPrice, Double> prices) {
        this.player = player;
        this.prices = prices;
    }

    @NotNull
    public String[] getDisplayStrings() {
        ArrayList<String> displayStrings = new ArrayList<String>();
        for (Map.Entry<ConfiguredPrice, Double> entry : this.prices.entrySet()) {
            displayStrings.add(entry.getKey().getDisplay(this.player, entry.getValue()));
        }
        return displayStrings.toArray(new String[0]);
    }

    @NotNull
    public static Builder builder(@NotNull Player player) {
        return new Builder(player);
    }

    public static class Builder {
        private final List<MultipliedPrice> prices = new ArrayList<MultipliedPrice>();
        private final Player player;

        Builder(@NotNull Player player) {
            this.player = player;
        }

        @NotNull
        public Builder add(@NotNull ConfiguredPrice price, double multiplier) {
            this.prices.add(new MultipliedPrice(price, multiplier));
            return this;
        }

        @NotNull
        public Builder add(@NotNull ConfiguredPrice price) {
            return this.add(price, 1.0);
        }

        @NotNull
        public CombinedDisplayPrice build() {
            HashMap<ConfiguredPrice, Double> unitPrices = new HashMap<ConfiguredPrice, Double>();
            for (MultipliedPrice price : this.prices) {
                ConfiguredPrice base = unitPrices.keySet().stream().filter(it -> it.getIdentifier().equals(price.price().getIdentifier())).findFirst().orElse(price.price());
                double unitMultiplier = 1.0 / base.getValue(this.player);
                double currentMultiplier = unitPrices.getOrDefault(base, 0.0);
                unitPrices.put(base, currentMultiplier += unitMultiplier * price.price().getValue(this.player, price.multiplier()));
            }
            return new CombinedDisplayPrice(this.player, unitPrices);
        }

        private record MultipliedPrice(@NotNull ConfiguredPrice price, double multiplier) {
        }
    }
}

