/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.config;

import com.willfp.eco.core.config.ConfigType;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.placeholder.InjectablePlaceholder;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.internal.config.ConfigUtilsKt;
import com.willfp.eco.internal.config.EcoConfigSection;
import com.willfp.eco.internal.fast.ListViewOfCollection;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0001H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0096\u0002J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\tH\u0096\u0002J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0017\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\u001c2\u0006\u0010%\u001a\u00020\u0015H\u0016J!\u0010&\u001a\n\u0012\u0004\u0012\u0002H'\u0018\u00010\u001c\"\u0006\b\u0000\u0010'\u0018\u00012\u0006\u0010\u0018\u001a\u00020\tH\u0082\bJ\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0016J\"\u0010)\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0016J(\u0010-\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010.\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0018\u00100\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\b\u00101\u001a\u00020\u0003H\u0016J\u0010\u00102\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\tH\u0016J\b\u00103\u001a\u00020\u0006H\u0016J0\u00104\u001a\u00020\u000f2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\r052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n05J$\u00106\u001a\b\u0012\u0004\u0012\u00020\t0\u001c2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\t082\u0006\u00109\u001a\u00020\tH\u0016J\u001b\u0010:\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\t2\b\u0010;\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010<\u001a\u00020=H\u0016J\u0016\u0010>\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\r0\bH\u0016J\b\u0010?\u001a\u00020\tH\u0016J\b\u0010@\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/willfp/eco/internal/config/EcoConfig;", "Lcom/willfp/eco/core/config/interfaces/Config;", "configType", "Lcom/willfp/eco/core/config/ConfigType;", "(Lcom/willfp/eco/core/config/ConfigType;)V", "injectionHash", "", "injections", "", "", "Lcom/willfp/eco/core/placeholder/InjectablePlaceholder;", "values", "Ljava/util/concurrent/ConcurrentHashMap;", "", "addInjectablePlaceholder", "", "placeholders", "", "clearInjectedPlaceholders", "clone", "equals", "", "other", "get", "path", "getBoolOrNull", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getBoolsOrNull", "", "getDoubleOrNull", "", "(Ljava/lang/String;)Ljava/lang/Double;", "getDoublesOrNull", "getIntOrNull", "(Ljava/lang/String;)Ljava/lang/Integer;", "getIntsOrNull", "getKeys", "deep", "getList", "T", "getPlaceholderInjections", "getStringOrNull", "format", "option", "Lcom/willfp/eco/util/StringUtils$FormatOption;", "getStringsOrNull", "getSubsection", "getSubsectionOrNull", "getSubsectionsOrNull", "getType", "has", "hashCode", "init", "", "recurseKeys", "current", "", "root", "set", "obj", "toBukkit", "Lorg/bukkit/configuration/file/YamlConfiguration;", "toMap", "toPlaintext", "toString", "core-backend"})
@SourceDebugExtension(value={"SMAP\nEcoConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcoConfig.kt\ncom/willfp/eco/internal/config/EcoConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ListViewOfCollection.kt\ncom/willfp/eco/internal/fast/ListViewOfCollectionKt\n*L\n1#1,255:1\n217#1,8:257\n217#1,8:269\n217#1,8:281\n217#1,8:289\n217#1,8:301\n1#2:256\n1549#3:265\n1620#3,3:266\n1549#3:277\n1620#3,3:278\n1549#3:297\n1620#3,3:298\n1549#3:309\n1620#3,3:310\n47#4:313\n*S KotlinDebug\n*F\n+ 1 EcoConfig.kt\ncom/willfp/eco/internal/config/EcoConfig\n*L\n117#1:257,8\n131#1:269,8\n139#1:281,8\n161#1:289,8\n181#1:301,8\n118#1:265\n118#1:266,3\n131#1:277\n131#1:278,3\n162#1:297\n162#1:298,3\n181#1:309\n181#1:310,3\n192#1:313\n*E\n"})
public class EcoConfig
implements Config {
    @NotNull
    private final ConfigType configType;
    @NotNull
    private final ConcurrentHashMap<String, Object> values;
    @NotNull
    private final transient Map<String, InjectablePlaceholder> injections;
    private transient int injectionHash;

    public EcoConfig(@NotNull ConfigType configType) {
        Intrinsics.checkNotNullParameter((Object)configType, "configType");
        this.configType = configType;
        this.values = new ConcurrentHashMap();
        this.injections = new LinkedHashMap();
    }

    public final void init(@NotNull Map<String, ? extends Object> values2, @NotNull Map<String, ? extends InjectablePlaceholder> injections) {
        Intrinsics.checkNotNullParameter(values2, "values");
        Intrinsics.checkNotNullParameter(injections, "injections");
        this.values.clear();
        this.values.putAll(ConfigUtilsKt.normalizeToConfig(values2, this.getType()));
        this.addInjectablePlaceholder((Iterable<? extends InjectablePlaceholder>)injections.values());
    }

    @Override
    @NotNull
    public String toPlaintext() {
        return ConfigUtilsKt.toString(this.configType, (Map<String, ? extends Object>)this.values);
    }

    @Override
    public boolean has(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.get(path) != null;
    }

    @Override
    @NotNull
    public List<String> getKeys(boolean deep) {
        List<String> list;
        if (deep) {
            list = this.recurseKeys(new LinkedHashSet(), "");
        } else {
            Set set = this.values.keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            list = CollectionsKt.toList(set);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> recurseKeys(@NotNull Set<String> current, @NotNull String root) {
        Intrinsics.checkNotNullParameter(current, "current");
        Intrinsics.checkNotNullParameter(root, "root");
        Set list = new LinkedHashSet();
        for (String key : this.getKeys(false)) {
            list.add(root + key);
            Object found = this.get(key);
            if (!(found instanceof Config)) continue;
            List<String> list2 = ((Config)found).recurseKeys(current, root + key + ".");
            Intrinsics.checkNotNullExpressionValue(list2, "recurseKeys(...)");
            list.addAll((Collection)list2);
        }
        return CollectionsKt.toList(list);
    }

    @Override
    @Nullable
    public Object get(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        String[] stringArray = new String[]{"."};
        String nearestPath = (String)StringsKt.split$default((CharSequence)path, stringArray, false, 0, 6, null).get(0);
        if (StringsKt.contains$default((CharSequence)path, ".", false, 2, null)) {
            String remainingPath = StringsKt.removePrefix(path, (CharSequence)(nearestPath + "."));
            if (((CharSequence)remainingPath).length() == 0) {
                return null;
            }
            Object first2 = this.get(nearestPath);
            return first2 instanceof Config ? ((Config)first2).get(remainingPath) : null;
        }
        return this.values.get(nearestPath);
    }

    @Override
    public void set(@NotNull String path, @Nullable Object obj) {
        Intrinsics.checkNotNullParameter(path, "path");
        String[] stringArray = new String[]{"."};
        String nearestPath = (String)StringsKt.split$default((CharSequence)path, stringArray, false, 0, 6, null).get(0);
        if (StringsKt.contains$default((CharSequence)path, ".", false, 2, null)) {
            String remainingPath = StringsKt.removePrefix(path, (CharSequence)(nearestPath + "."));
            if (((CharSequence)remainingPath).length() == 0) {
                return;
            }
            Config section = this.getSubsection(nearestPath);
            section.set(remainingPath, obj);
            ((Map)this.values).put(nearestPath, section);
            return;
        }
        if (obj == null) {
            this.values.remove(nearestPath);
        } else {
            ((Map)this.values).put(nearestPath, ConfigUtilsKt.constrainConfigTypes(obj, this.getType()));
        }
    }

    @Override
    @NotNull
    public Config getSubsection(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Config config = this.getSubsectionOrNull(path);
        if (config == null) {
            config = new EcoConfigSection(this.getType(), null, this.injections, 2, null);
        }
        return config;
    }

    @Override
    @Nullable
    public Config getSubsectionOrNull(@NotNull String path) {
        Object object;
        Intrinsics.checkNotNullParameter(path, "path");
        Object object2 = this.get(path);
        Config config = object2 instanceof Config ? (Config)object2 : null;
        if (config != null) {
            Object $this$getSubsectionOrNull_u24lambda_u240 = object2 = config;
            boolean bl = false;
            $this$getSubsectionOrNull_u24lambda_u240.addInjectablePlaceholder((Iterable<InjectablePlaceholder>)this.injections.values());
            object = object2;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public List<Config> getSubsectionsOrNull(@NotNull String path) {
        List list;
        List list2;
        Iterable asIterable$iv;
        Intrinsics.checkNotNullParameter(path, "path");
        EcoConfig this_$iv = this;
        boolean $i$f$getList2 = false;
        Object object = this_$iv.get(path);
        Iterable iterable = object instanceof Iterable ? (Iterable)object : null;
        if (iterable == null) {
            v1 = null;
        } else {
            asIterable$iv = iterable;
            List asList$iv = CollectionsKt.toList(asIterable$iv);
            Object t2 = CollectionsKt.firstOrNull(asList$iv);
            if (!(t2 != null ? t2 instanceof Config : true)) {
                v1 = CollectionsKt.emptyList();
            } else {
                Intrinsics.checkNotNull(asList$iv, "null cannot be cast to non-null type kotlin.collections.List<T of com.willfp.eco.internal.config.EcoConfig.getList>");
                v1 = list2 = asList$iv;
            }
        }
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $i$f$getList2 = list2;
            boolean $i$f$map = false;
            asIterable$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                void var13_15;
                Config config = (Config)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void $this$getSubsectionsOrNull_u24lambda_u242_u24lambda_u241 = var13_15 = it;
                boolean bl2 = false;
                $this$getSubsectionsOrNull_u24lambda_u242_u24lambda_u241.addInjectablePlaceholder((Iterable<InjectablePlaceholder>)this.injections.values());
                collection.add(var13_15);
            }
            list = CollectionsKt.toList((List)destination$iv$iv);
        } else {
            list = null;
        }
        return list;
    }

    @Override
    @NotNull
    public ConfigType getType() {
        return this.configType;
    }

    @Override
    @Nullable
    public Integer getIntOrNull(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Object object = this.get(path);
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
        return number != null ? Integer.valueOf(number.intValue()) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<Integer> getIntsOrNull(@NotNull String path) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter(path, "path");
        EcoConfig this_$iv = this;
        boolean $i$f$getList = false;
        Object object = this_$iv.get(path);
        Iterable iterable = object instanceof Iterable ? (Iterable)object : null;
        if (iterable == null) {
            list2 = null;
        } else {
            Iterable asIterable$iv = iterable;
            List asList$iv = CollectionsKt.toList(asIterable$iv);
            Object t2 = CollectionsKt.firstOrNull(asList$iv);
            if (!(t2 != null ? t2 instanceof Number : true)) {
                list2 = CollectionsKt.emptyList();
            } else {
                Intrinsics.checkNotNull(asList$iv, "null cannot be cast to non-null type kotlin.collections.List<T of com.willfp.eco.internal.config.EcoConfig.getList>");
                list2 = asList$iv;
            }
        }
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Number number = (Number)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.intValue());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Override
    @Nullable
    public Boolean getBoolOrNull(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Object object = this.get(path);
        return object instanceof Boolean ? (Boolean)object : null;
    }

    @Override
    @Nullable
    public List<Boolean> getBoolsOrNull(@NotNull String path) {
        List list;
        Intrinsics.checkNotNullParameter(path, "path");
        EcoConfig this_$iv = this;
        boolean $i$f$getList = false;
        Object object = this_$iv.get(path);
        Iterable iterable = object instanceof Iterable ? (Iterable)object : null;
        if (iterable == null) {
            list = null;
        } else {
            Iterable asIterable$iv = iterable;
            List asList$iv = CollectionsKt.toList(asIterable$iv);
            Object t2 = CollectionsKt.firstOrNull(asList$iv);
            if (!(t2 != null ? t2 instanceof Boolean : true)) {
                list = CollectionsKt.emptyList();
            } else {
                Intrinsics.checkNotNull(asList$iv, "null cannot be cast to non-null type kotlin.collections.List<T of com.willfp.eco.internal.config.EcoConfig.getList>");
                list = asList$iv;
            }
        }
        return list != null ? CollectionsKt.toList(list) : null;
    }

    @Override
    @Nullable
    public String getStringOrNull(@NotNull String path, boolean format, @NotNull StringUtils.FormatOption option) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter((Object)option, "option");
        Object object = this.get(path);
        if (object == null || (object = object.toString()) == null) {
            return null;
        }
        Object string = object;
        if (format && option == StringUtils.FormatOption.WITH_PLACEHOLDERS) {
            for (InjectablePlaceholder injection : this.getPlaceholderInjections()) {
                Intrinsics.checkNotNullExpressionValue(injection.tryTranslateQuickly((String)string, PlaceholderContext.EMPTY), "tryTranslateQuickly(...)");
            }
        }
        return format ? StringUtils.format((String)string, option) : string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<String> getStringsOrNull(@NotNull String path, boolean format, @NotNull StringUtils.FormatOption option) {
        List<String> list;
        block11: {
            block10: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list2;
                Iterable asIterable$iv;
                Intrinsics.checkNotNullParameter(path, "path");
                Intrinsics.checkNotNullParameter((Object)option, "option");
                EcoConfig this_$iv = this;
                boolean $i$f$getList22 = false;
                Object object = this_$iv.get(path);
                Iterable iterable = object instanceof Iterable ? (Iterable)object : null;
                if (iterable == null) {
                    v1 = null;
                } else {
                    asIterable$iv = iterable;
                    List asList$iv = CollectionsKt.toList(asIterable$iv);
                    Object t2 = CollectionsKt.firstOrNull(asList$iv);
                    if (!(t2 != null ? t2 instanceof Object : true)) {
                        v1 = CollectionsKt.emptyList();
                    } else {
                        Intrinsics.checkNotNull(asList$iv, "null cannot be cast to non-null type kotlin.collections.List<T of com.willfp.eco.internal.config.EcoConfig.getList>");
                        v1 = list2 = asList$iv;
                    }
                }
                if (list2 == null) break block10;
                Iterable $i$f$getList22 = list2;
                boolean $i$f$map = false;
                asIterable$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t3 = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it;
                    if (string == null || (string = string.toString()) == null) {
                        string = "";
                    }
                    collection.add(string);
                }
                list = CollectionsKt.toMutableList((List)destination$iv$iv);
                if (list != null) break block11;
            }
            return null;
        }
        List<String> strings = list;
        if (!((Collection)this.getPlaceholderInjections()).isEmpty() && format && option == StringUtils.FormatOption.WITH_PLACEHOLDERS) {
            strings.replaceAll(arg_0 -> EcoConfig.getStringsOrNull$lambda$5(this, arg_0));
        }
        return format ? StringUtils.formatList(strings, option) : strings;
    }

    @Override
    @Nullable
    public Double getDoubleOrNull(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Object object = this.get(path);
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
        return number != null ? Double.valueOf(number.doubleValue()) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<Double> getDoublesOrNull(@NotNull String path) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter(path, "path");
        EcoConfig this_$iv = this;
        boolean $i$f$getList = false;
        Object object = this_$iv.get(path);
        Iterable iterable = object instanceof Iterable ? (Iterable)object : null;
        if (iterable == null) {
            list2 = null;
        } else {
            Iterable asIterable$iv = iterable;
            List asList$iv = CollectionsKt.toList(asIterable$iv);
            Object t2 = CollectionsKt.firstOrNull(asList$iv);
            if (!(t2 != null ? t2 instanceof Number : true)) {
                list2 = CollectionsKt.emptyList();
            } else {
                Intrinsics.checkNotNull(asList$iv, "null cannot be cast to non-null type kotlin.collections.List<T of com.willfp.eco.internal.config.EcoConfig.getList>");
                list2 = asList$iv;
            }
        }
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Number number = (Number)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.doubleValue());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    public void addInjectablePlaceholder(@NotNull Iterable<? extends InjectablePlaceholder> placeholders) {
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        for (InjectablePlaceholder injectablePlaceholder : placeholders) {
            Map<String, InjectablePlaceholder> map2 = this.injections;
            String string = injectablePlaceholder.getPattern().pattern();
            Intrinsics.checkNotNullExpressionValue(string, "pattern(...)");
            map2.put(string, injectablePlaceholder);
            this.injectionHash ^= injectablePlaceholder.hashCode();
        }
    }

    @Override
    @NotNull
    public List<InjectablePlaceholder> getPlaceholderInjections() {
        Collection<InjectablePlaceholder> $this$listView$iv = this.injections.values();
        boolean $i$f$listView = false;
        return new ListViewOfCollection<InjectablePlaceholder>($this$listView$iv);
    }

    @Override
    public void clearInjectedPlaceholders() {
        this.injections.clear();
        this.injectionHash = 0;
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return MapsKt.toMutableMap((Map)this.values);
    }

    @NotNull
    public YamlConfiguration toBukkit() {
        YamlConfiguration temp = new YamlConfiguration();
        temp.createSection("temp", MapsKt.toMap((Map)this.values));
        ConfigurationSection configurationSection = temp.getConfigurationSection("temp");
        Intrinsics.checkNotNull(configurationSection);
        ConfigurationSection section = configurationSection;
        YamlConfiguration bukkit = new YamlConfiguration();
        for (String key : section.getKeys(true)) {
            bukkit.set(key, section.get(key));
        }
        return bukkit;
    }

    private final /* synthetic */ <T> List<T> getList(String path) {
        boolean $i$f$getList = false;
        Object object = this.get(path);
        Iterable iterable = object instanceof Iterable ? (Iterable)object : null;
        if (iterable == null) {
            return null;
        }
        Iterable asIterable = iterable;
        List asList2 = CollectionsKt.toList(asIterable);
        Object t2 = CollectionsKt.firstOrNull(asList2);
        Intrinsics.reifiedOperationMarker(3, "T?");
        if (!(t2 instanceof Object)) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNull(asList2, "null cannot be cast to non-null type kotlin.collections.List<T of com.willfp.eco.internal.config.EcoConfig.getList>");
        return asList2;
    }

    @Override
    @NotNull
    public Config clone() {
        return new EcoConfigSection(this.getType(), MapsKt.toMutableMap((Map)this.values), this.injections);
    }

    @NotNull
    public String toString() {
        return this.toPlaintext();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EcoConfig)) {
            return false;
        }
        return this.hashCode() == ((EcoConfig)other).hashCode();
    }

    public int hashCode() {
        int identityHash = System.identityHashCode(this);
        return (identityHash << 5) - (identityHash ^ this.configType.hashCode()) + this.injectionHash;
    }

    private static final String getStringsOrNull$lambda$5(EcoConfig this$0, String it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        String string = it;
        for (InjectablePlaceholder injection : this$0.getPlaceholderInjections()) {
            Intrinsics.checkNotNullExpressionValue(injection.tryTranslateQuickly(string, PlaceholderContext.EMPTY), "tryTranslateQuickly(...)");
        }
        return string;
    }
}

