/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.drops;

import com.willfp.eco.internal.drops.EcoDropQueue;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0002\u0007\bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/internal/drops/EcoFastCollatedDropQueue;", "Lcom/willfp/eco/internal/drops/EcoDropQueue;", "player", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;)V", "push", "", "CollatedDrops", "Companion", "core-backend"})
public final class EcoFastCollatedDropQueue
extends EcoDropQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<Player, CollatedDrops> COLLATED_MAP = new ConcurrentHashMap();

    public EcoFastCollatedDropQueue(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        super(player);
    }

    @Override
    public void push() {
        CollatedDrops fetched = COLLATED_MAP.get(this.getPlayer());
        if (fetched == null) {
            COLLATED_MAP.put(this.getPlayer(), new CollatedDrops(this.getItems(), this.getLocation(), this.getXp(), this.getHasTelekinesis()));
        } else {
            fetched.addDrops(this.getItems());
            fetched.setLocation(this.getLocation());
            fetched.addXp(this.getXp());
            if (this.getHasTelekinesis()) {
                fetched.forceTelekinesis();
            }
            COLLATED_MAP.put(this.getPlayer(), fetched);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u001a\u001a\u00020\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u001e\u001a\u00020\u001fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lcom/willfp/eco/internal/drops/EcoFastCollatedDropQueue$CollatedDrops;", "", "drops", "", "Lorg/bukkit/inventory/ItemStack;", "location", "Lorg/bukkit/Location;", "xp", "", "telekinetic", "", "(Ljava/util/List;Lorg/bukkit/Location;IZ)V", "getDrops", "()Ljava/util/List;", "getLocation", "()Lorg/bukkit/Location;", "setLocation", "(Lorg/bukkit/Location;)V", "getTelekinetic", "()Z", "setTelekinetic", "(Z)V", "getXp", "()I", "setXp", "(I)V", "addDrops", "toAdd", "", "addXp", "forceTelekinesis", "", "core-backend"})
    public static final class CollatedDrops {
        @NotNull
        private final List<ItemStack> drops;
        @NotNull
        private Location location;
        private int xp;
        private boolean telekinetic;

        public CollatedDrops(@NotNull List<ItemStack> drops, @NotNull Location location, int xp, boolean telekinetic) {
            Intrinsics.checkNotNullParameter(drops, "drops");
            Intrinsics.checkNotNullParameter(location, "location");
            this.drops = drops;
            this.location = location;
            this.xp = xp;
            this.telekinetic = telekinetic;
        }

        @NotNull
        public final List<ItemStack> getDrops() {
            return this.drops;
        }

        @NotNull
        public final Location getLocation() {
            return this.location;
        }

        public final void setLocation(@NotNull Location location) {
            Intrinsics.checkNotNullParameter(location, "<set-?>");
            this.location = location;
        }

        public final int getXp() {
            return this.xp;
        }

        public final void setXp(int n) {
            this.xp = n;
        }

        public final boolean getTelekinetic() {
            return this.telekinetic;
        }

        public final void setTelekinetic(boolean bl) {
            this.telekinetic = bl;
        }

        @NotNull
        public final CollatedDrops addDrops(@NotNull List<? extends ItemStack> toAdd) {
            Intrinsics.checkNotNullParameter(toAdd, "toAdd");
            this.drops.addAll((Collection<ItemStack>)toAdd);
            return this;
        }

        @NotNull
        public final CollatedDrops addXp(int xp) {
            this.xp += xp;
            return this;
        }

        public final void forceTelekinesis() {
            this.telekinetic = true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/internal/drops/EcoFastCollatedDropQueue$Companion;", "", "()V", "COLLATED_MAP", "", "Lorg/bukkit/entity/Player;", "Lcom/willfp/eco/internal/drops/EcoFastCollatedDropQueue$CollatedDrops;", "getCOLLATED_MAP", "()Ljava/util/Map;", "core-backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Player, CollatedDrops> getCOLLATED_MAP() {
            return COLLATED_MAP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

