/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.items;

import com.willfp.eco.core.fast.FastItemStackExtensions;
import com.willfp.eco.core.items.args.LookupArgParser;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NamespacedKeyUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/willfp/eco/internal/items/ArgParserEnchantment;", "Lcom/willfp/eco/core/items/args/LookupArgParser;", "()V", "parseArguments", "Ljava/util/function/Predicate;", "Lorg/bukkit/inventory/ItemStack;", "args", "", "", "meta", "Lorg/bukkit/inventory/meta/ItemMeta;", "([Ljava/lang/String;Lorg/bukkit/inventory/meta/ItemMeta;)Ljava/util/function/Predicate;", "serializeBack", "core-backend"})
public final class ArgParserEnchantment
implements LookupArgParser {
    @NotNull
    public static final ArgParserEnchantment INSTANCE = new ArgParserEnchantment();

    private ArgParserEnchantment() {
    }

    @Override
    @Nullable
    public Predicate<ItemStack> parseArguments(@NotNull String[] args2, @NotNull ItemMeta meta) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(meta, "meta");
        Map enchants = new LinkedHashMap();
        for (String arg : args2) {
            String[] stringArray = new String[]{":"};
            List argSplit = StringsKt.split$default((CharSequence)arg, stringArray, false, 0, 6, null);
            if (argSplit.size() < 2) continue;
            Enchantment enchant = Enchantment.getByKey((NamespacedKey)NamespacedKeyUtils.create("minecraft", (String)argSplit.get(0)));
            Integer level = StringsKt.toIntOrNull((String)argSplit.get(1));
            if (enchant == null || level == null) continue;
            enchants.put(enchant, level);
        }
        if (enchants.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : enchants.entrySet()) {
            Enchantment enchant = (Enchantment)entry.getKey();
            int level = ((Number)entry.getValue()).intValue();
            if (meta instanceof EnchantmentStorageMeta) {
                ((EnchantmentStorageMeta)meta).addStoredEnchant(enchant, level, true);
                continue;
            }
            meta.addEnchant(enchant, level, true);
        }
        return arg_0 -> ArgParserEnchantment.parseArguments$lambda$0(enchants, arg_0);
    }

    @Override
    @Nullable
    public String serializeBack(@NotNull ItemMeta meta) {
        Intrinsics.checkNotNullParameter(meta, "meta");
        Map enchants = new LinkedHashMap();
        if (meta instanceof EnchantmentStorageMeta) {
            Map map2 = ((EnchantmentStorageMeta)meta).getStoredEnchants();
            Intrinsics.checkNotNullExpressionValue(map2, "getStoredEnchants(...)");
            enchants.putAll(map2);
        } else {
            Map map3 = meta.getEnchants();
            Intrinsics.checkNotNullExpressionValue(map3, "getEnchants(...)");
            enchants.putAll(map3);
        }
        if (enchants.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : enchants.entrySet()) {
            Enchantment enchant = (Enchantment)entry.getKey();
            int level = ((Number)entry.getValue()).intValue();
            builder.append(enchant.getKey().getKey() + ":" + level + " ");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
    }

    private static final boolean parseArguments$lambda$0(Map $enchants, ItemStack it) {
        Intrinsics.checkNotNullParameter($enchants, "$enchants");
        Intrinsics.checkNotNullParameter(it, "it");
        Map<Enchantment, Integer> map2 = FastItemStackExtensions.fast(it).getEnchants(true);
        Intrinsics.checkNotNullExpressionValue(map2, "getEnchants(...)");
        Map<Enchantment, Integer> onItem = map2;
        for (Map.Entry entry : $enchants.entrySet()) {
            Enchantment enchant = (Enchantment)entry.getKey();
            int level = ((Number)entry.getValue()).intValue();
            Integer n = onItem.get(enchant);
            if ((n != null ? n : 0) >= level) continue;
            return false;
        }
        return true;
    }
}

