/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.logging;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/internal/logging/EcoLogger;", "Ljava/util/logging/Logger;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "info", "", "msg", "", "core-backend"})
public final class EcoLogger
extends Logger {
    @NotNull
    private final EcoPlugin plugin;

    public EcoLogger(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        super(plugin.getName(), null);
        this.plugin = plugin;
        this.setParent(this.plugin.getServer().getLogger());
        this.setLevel(Level.ALL);
    }

    @Override
    public void info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Bukkit.getConsoleSender().sendMessage("[" + this.plugin.getName() + "] " + StringUtils.format(msg, StringUtils.FormatOption.WITHOUT_PLACEHOLDERS));
    }
}

