/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.placeholder;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.integrations.placeholder.PlaceholderManager;
import com.willfp.eco.core.placeholder.InjectablePlaceholder;
import com.willfp.eco.core.placeholder.Placeholder;
import com.willfp.eco.internal.placeholder.PlaceholderLookupKt;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0000H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/willfp/eco/internal/placeholder/PlaceholderLookup;", "", "args", "", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "injections", "", "Lcom/willfp/eco/core/placeholder/InjectablePlaceholder;", "(Ljava/lang/String;Lcom/willfp/eco/core/EcoPlugin;Ljava/util/Collection;)V", "getArgs", "()Ljava/lang/String;", "getPlugin", "()Lcom/willfp/eco/core/EcoPlugin;", "findMatchingPlaceholder", "Lcom/willfp/eco/core/placeholder/Placeholder;", "matches", "", "lookup", "core-backend"})
public final class PlaceholderLookup {
    @NotNull
    private final String args;
    @Nullable
    private final EcoPlugin plugin;
    @Nullable
    private final Collection<InjectablePlaceholder> injections;

    public PlaceholderLookup(@NotNull String args2, @Nullable EcoPlugin plugin, @Nullable Collection<? extends InjectablePlaceholder> injections) {
        Intrinsics.checkNotNullParameter(args2, "args");
        this.args = args2;
        this.plugin = plugin;
        this.injections = injections;
    }

    @NotNull
    public final String getArgs() {
        return this.args;
    }

    @Nullable
    public final EcoPlugin getPlugin() {
        return this.plugin;
    }

    @Nullable
    public final Placeholder findMatchingPlaceholder() {
        if (this.plugin != null) {
            Set<Placeholder> pluginPlaceholders = PlaceholderManager.getRegisteredPlaceholders(this.plugin);
            for (Placeholder placeholder2 : pluginPlaceholders) {
                Intrinsics.checkNotNull(placeholder2);
                if (!this.matches(placeholder2, this)) continue;
                return placeholder2;
            }
        }
        if (this.injections != null) {
            for (InjectablePlaceholder injectablePlaceholder : this.injections) {
                if (!this.matches(injectablePlaceholder, this)) continue;
                return injectablePlaceholder;
            }
        }
        for (Placeholder placeholder2 : PlaceholderLookupKt.access$getGlobalPlaceholders$p()) {
            if (!this.matches(placeholder2, this)) continue;
            return placeholder2;
        }
        return null;
    }

    private final boolean matches(Placeholder $this$matches, PlaceholderLookup lookup) {
        Pattern pattern = $this$matches.getPattern();
        Intrinsics.checkNotNullExpressionValue(pattern, "getPattern(...)");
        Pattern pattern2 = pattern;
        String patternString = pattern2.pattern();
        int patternFlags = pattern2.flags();
        boolean isLiteral = (0x10 & patternFlags) != 0;
        return isLiteral ? Intrinsics.areEqual(lookup.args, patternString) : pattern2.matcher(lookup.args).matches();
    }
}

