/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.proxy;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.proxy.ProxyConstants;
import com.willfp.eco.core.proxy.ProxyFactory;
import com.willfp.eco.core.proxy.exceptions.ProxyError;
import com.willfp.eco.core.proxy.exceptions.UnsupportedVersionError;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.net.URLClassLoader;
import java.util.IdentityHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\b\b\u0000\u0010\f*\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u0007H\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J%\u0010\u0011\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u0007H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0002R\"\u0010\u0005\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/willfp/eco/internal/proxy/EcoProxyFactory;", "Lcom/willfp/eco/core/proxy/ProxyFactory;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "cache", "", "Ljava/lang/Class;", "", "proxyClassLoader", "Ljava/lang/ClassLoader;", "attemptCache", "T", "proxyClass", "(Ljava/lang/Class;)Ljava/lang/Object;", "clean", "", "getProxy", "proxyErrorFrom", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "core-backend"})
public final class EcoProxyFactory
implements ProxyFactory {
    @NotNull
    private final EcoPlugin plugin;
    @NotNull
    private final ClassLoader proxyClassLoader;
    @NotNull
    private final Map<Class<? extends Object>, Object> cache;

    public EcoProxyFactory(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        ClassLoader classLoader = this.plugin.getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue(classLoader, "getClassLoader(...)");
        this.proxyClassLoader = classLoader;
        this.cache = new IdentityHashMap();
    }

    @Override
    @NotNull
    public <T> T getProxy(@NotNull Class<T> proxyClass) {
        Intrinsics.checkNotNullParameter(proxyClass, "proxyClass");
        try {
            T cachedProxy = this.attemptCache(proxyClass);
            if (cachedProxy != null) {
                return cachedProxy;
            }
            String string = this.plugin.getProxyPackage();
            String string2 = proxyClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
            String className = string + "." + ProxyConstants.NMS_VERSION + "." + StringsKt.replace$default(string2, "Proxy", "", false, 4, null);
            Class<?> clazz = this.plugin.getClass().getClassLoader().loadClass(className);
            Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (proxyClass.isAssignableFrom(clazz) && proxyClass.isInstance(instance)) {
                T proxy = proxyClass.cast(instance);
                Intrinsics.checkNotNull(proxy);
                this.cache.put(proxyClass, proxy);
                return proxy;
            }
        }
        catch (Exception e) {
            throw this.proxyErrorFrom(e);
        }
        throw this.proxyErrorFrom(new IllegalArgumentException("Class doesn't seem to be a proxy."));
    }

    private final Throwable proxyErrorFrom(Exception e) {
        this.plugin.getLogger().severe("Fatal error with proxies! This plugin can't load.");
        return !ProxyConstants.SUPPORTED_VERSIONS.contains(ProxyConstants.NMS_VERSION) ? (Throwable)new ProxyError("Could not initialize proxy.", new UnsupportedVersionError()) : (Throwable)new ProxyError("Could not initialize proxy. If you're seeing this error message, something has gone badly wrong. This almost definitely isn't user error, blame the developer.", e);
    }

    private final <T> T attemptCache(Class<T> proxyClass) {
        Object object = this.cache.get(proxyClass);
        if (object == null) {
            return null;
        }
        Object proxy = object;
        if (proxyClass.isInstance(proxy)) {
            return proxyClass.cast(proxy);
        }
        return null;
    }

    public final void clean() {
        if (this.proxyClassLoader instanceof URLClassLoader) {
            ((URLClassLoader)this.proxyClassLoader).close();
        }
        this.cache.clear();
    }
}

