/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.scheduling;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.scheduling.Scheduler;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J \u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/willfp/eco/internal/scheduling/EcoScheduler;", "Lcom/willfp/eco/core/scheduling/Scheduler;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "cancelAll", "", "run", "Lorg/bukkit/scheduler/BukkitTask;", "runnable", "Ljava/lang/Runnable;", "runAsync", "runAsyncTimer", "delay", "", "repeat", "runLater", "ticksLater", "runTimer", "syncRepeating", "", "core-backend"})
public final class EcoScheduler
implements Scheduler {
    @NotNull
    private final EcoPlugin plugin;

    public EcoScheduler(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public BukkitTask runLater(@NotNull Runnable runnable, long ticksLater) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, runnable, ticksLater);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskLater(...)");
        return bukkitTask;
    }

    @Override
    @NotNull
    public BukkitTask runTimer(@NotNull Runnable runnable, long delay, long repeat) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, runnable, delay, repeat);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimer(...)");
        return bukkitTask;
    }

    @Override
    @NotNull
    public BukkitTask runAsyncTimer(@NotNull Runnable runnable, long delay, long repeat) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, runnable, delay, repeat);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimerAsynchronously(...)");
        return bukkitTask;
    }

    @Override
    @NotNull
    public BukkitTask run(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        BukkitTask bukkitTask = Bukkit.getScheduler().runTask((Plugin)this.plugin, runnable);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTask(...)");
        return bukkitTask;
    }

    @Override
    @NotNull
    public BukkitTask runAsync(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, runnable);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskAsynchronously(...)");
        return bukkitTask;
    }

    @Override
    public int syncRepeating(@NotNull Runnable runnable, long delay, long repeat) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        return Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, runnable, delay, repeat);
    }

    @Override
    public void cancelAll() {
        Bukkit.getScheduler().cancelTasks((Plugin)this.plugin);
    }
}

