/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.data;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.internal.spigot.data.EcoProfile;
import com.willfp.eco.internal.spigot.data.ProfileHandler;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.PlayerUtils;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/willfp/eco/internal/spigot/data/DataListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "handler", "Lcom/willfp/eco/internal/spigot/data/ProfileHandler;", "(Lcom/willfp/eco/core/EcoPlugin;Lcom/willfp/eco/internal/spigot/data/ProfileHandler;)V", "onJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onLeave", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onLogin", "Lorg/bukkit/event/player/PlayerLoginEvent;", "core-plugin"})
public final class DataListener
implements Listener {
    @NotNull
    private final EcoPlugin plugin;
    @NotNull
    private final ProfileHandler handler;

    public DataListener(@NotNull EcoPlugin plugin, @NotNull ProfileHandler handler) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.plugin = plugin;
        this.handler = handler;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onLeave(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        UUID uUID = event.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        EcoProfile ecoProfile = this.handler.accessLoadedProfile(uUID);
        if (ecoProfile == null) {
            return;
        }
        EcoProfile profile2 = ecoProfile;
        UUID uUID2 = event.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        this.handler.saveKeysFor(uUID2, profile2.getData().keySet());
        UUID uUID3 = event.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
        this.handler.unloadPlayer(uUID3);
    }

    @EventHandler
    public final void onJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.plugin.getScheduler().runLater(5L, () -> DataListener.onJoin$lambda$0(event));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public final void onLogin(@NotNull PlayerLoginEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        UUID uUID = event.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.handler.unloadPlayer(uUID);
    }

    private static final void onJoin$lambda$0(PlayerJoinEvent $event) {
        Intrinsics.checkNotNullParameter($event, "$event");
        PlayerUtils.updateSavedDisplayName($event.getPlayer());
    }
}

