/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.gui;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.gui.GUIHelperExtensions;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.core.tuples.Pair;
import com.willfp.eco.internal.gui.menu.EcoMenu;
import com.willfp.eco.internal.gui.menu.MenuHandler;
import com.willfp.eco.internal.gui.menu.MenuHandlerKt;
import com.willfp.eco.internal.gui.menu.RenderedInventory;
import com.willfp.eco.internal.gui.menu.RenderedInventoryKt;
import com.willfp.eco.internal.gui.slot.EcoSlot;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.MenuUtils;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0007J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0007J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0011H\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0007J.\u0010\u0014\u001a\u00020\b*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0006H\u0002J\f\u0010\u001b\u001a\u00020\b*\u00020\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/willfp/eco/internal/spigot/gui/GUIListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "depthLimit", "", "handleClose", "", "event", "Lorg/bukkit/event/inventory/InventoryCloseEvent;", "handleShiftClick", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "handleSlotClick", "Lorg/bukkit/event/inventory/InventoryDragEvent;", "preventMovingHeld", "preventNumberKey", "Lorg/bukkit/event/player/PlayerItemHeldEvent;", "preventNumberKey2", "temporaryExploitPatch", "handle", "Lcom/willfp/eco/core/gui/slot/Slot;", "player", "Lorg/bukkit/entity/Player;", "menu", "Lcom/willfp/eco/internal/gui/menu/EcoMenu;", "depth", "renderActiveMenu", "core-plugin"})
public final class GUIListener
implements Listener {
    @NotNull
    private final EcoPlugin plugin;
    private final int depthLimit;

    public GUIListener(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.depthLimit = 32;
    }

    private final void handle(Slot $this$handle, Player player, InventoryClickEvent event, EcoMenu menu, int depth) {
        if (depth == 0) {
            event.setCancelled(true);
        }
        if (depth >= this.depthLimit) {
            return;
        }
        Slot slot = $this$handle.getActionableSlot(player, menu);
        Intrinsics.checkNotNullExpressionValue(slot, "getActionableSlot(...)");
        Slot delegate = slot;
        if (delegate instanceof EcoSlot) {
            ((EcoSlot)delegate).handleInventoryClick(event, menu);
            if (delegate.shouldRenderOnClick(event.getClick())) {
                this.renderActiveMenu(player);
            }
        } else {
            if (delegate == $this$handle) {
                return;
            }
            this.handle(delegate, player, event, menu, depth + 1);
        }
    }

    static /* synthetic */ void handle$default(GUIListener gUIListener, Slot slot, Player player, InventoryClickEvent inventoryClickEvent, EcoMenu ecoMenu, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        gUIListener.handle(slot, player, inventoryClickEvent, ecoMenu, n);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public final void handleSlotClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Object object = event.getClickedInventory();
        if (object == null || (object = MenuHandlerKt.asRenderedInventory((Inventory)object)) == null) {
            return;
        }
        Object rendered = object;
        Object object2 = event.getWhoClicked();
        Player player = object2 instanceof Player ? (Player)object2 : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        EcoMenu menu = ((RenderedInventory)rendered).getMenu();
        object2 = MenuUtils.convertSlotToRowColumn(event.getSlot(), menu.getColumns());
        Integer row2 = (Integer)((Pair)object2).component1();
        Integer column = (Integer)((Pair)object2).component2();
        Intrinsics.checkNotNull(row2);
        int n = row2;
        Intrinsics.checkNotNull(column);
        GUIListener.handle$default(this, menu.getSlot(n, column, player2), player2, event, menu, 0, 8, null);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public final void handleSlotClick(@NotNull InventoryDragEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Inventory inventory = event.getView().getTopInventory();
        Intrinsics.checkNotNullExpressionValue(inventory, "getTopInventory(...)");
        RenderedInventory renderedInventory = MenuHandlerKt.asRenderedInventory(inventory);
        if (renderedInventory == null) {
            return;
        }
        RenderedInventory rendered = renderedInventory;
        HumanEntity humanEntity = event.getWhoClicked();
        Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        EcoMenu menu = rendered.getMenu();
        Set set = event.getInventorySlots();
        Intrinsics.checkNotNullExpressionValue(set, "getInventorySlots(...)");
        Set slots = set;
        for (Integer slotID : slots) {
            Intrinsics.checkNotNull(slotID);
            Pair<Integer, Integer> pair = MenuUtils.convertSlotToRowColumn(slotID, menu.getColumns());
            Integer row2 = pair.component1();
            Integer column = pair.component2();
            Intrinsics.checkNotNull(row2);
            int n = row2;
            Intrinsics.checkNotNull(column);
            Slot slot = menu.getSlot(n, column, player2);
            if (slot.isCaptive(player2, menu)) {
                if (!slot.isAllowedCaptive(player2, menu, event.getOldCursor())) {
                    event.setCancelled(true);
                    continue;
                }
                this.renderActiveMenu(player2);
                continue;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public final void handleShiftClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.isShiftClick()) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        Inventory inventory = player2.getOpenInventory().getTopInventory();
        Intrinsics.checkNotNullExpressionValue(inventory, "getTopInventory(...)");
        Inventory inv = inventory;
        if (Intrinsics.areEqual(inv, event.getClickedInventory())) {
            return;
        }
        Menu menu = MenuHandlerKt.getMenu(inv);
        if (menu == null) {
            return;
        }
        Menu menu2 = menu;
        Pair<Integer, Integer> pair = MenuUtils.convertSlotToRowColumn(inv.firstEmpty(), menu2.getColumns());
        Integer row2 = pair.component1();
        Integer column = pair.component2();
        Intrinsics.checkNotNull(row2);
        int n = row2;
        Intrinsics.checkNotNull(column);
        Slot slot = menu2.getSlot(n, column, player2);
        if (slot.isCaptive(player2, menu2)) {
            if (!slot.isAllowedCaptive(player2, menu2, event.getCurrentItem())) {
                event.setCancelled(true);
            } else {
                this.renderActiveMenu(player2);
            }
        } else {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public final void handleClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Inventory inventory = event.getInventory();
        Intrinsics.checkNotNullExpressionValue(inventory, "getInventory(...)");
        Menu menu = MenuHandlerKt.getMenu(inventory);
        EcoMenu ecoMenu = menu instanceof EcoMenu ? (EcoMenu)menu : null;
        if (ecoMenu == null) {
            return;
        }
        EcoMenu menu2 = ecoMenu;
        HumanEntity humanEntity = event.getPlayer();
        Intrinsics.checkNotNull(humanEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
        menu2.refresh((Player)humanEntity);
        menu2.handleClose(event);
        this.plugin.getScheduler().run(() -> GUIListener.handleClose$lambda$0(event));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void preventNumberKey(@NotNull PlayerItemHeldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory(player2);
        if (renderedInventory == null) {
            return;
        }
        RenderedInventory rendered = renderedInventory;
        if (rendered.getMenu().allowsChangingHeldItem()) {
            this.renderActiveMenu(player2);
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void preventMovingHeld(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = GUIHelperExtensions.getPlayer(event);
        RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory(player);
        if (renderedInventory == null) {
            return;
        }
        RenderedInventory rendered = renderedInventory;
        if (rendered.getMenu().allowsChangingHeldItem()) {
            return;
        }
        if (!(event.getClickedInventory() instanceof PlayerInventory)) {
            return;
        }
        if (event.getSlot() == player.getInventory().getHeldItemSlot()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public final void preventNumberKey2(@NotNull PlayerItemHeldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory(player2);
        if (renderedInventory == null) {
            return;
        }
        RenderedInventory rendered = renderedInventory;
        if (rendered.getMenu().allowsChangingHeldItem()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void preventNumberKey(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = GUIHelperExtensions.getPlayer(event);
        if (event.getClick() != ClickType.NUMBER_KEY) {
            return;
        }
        RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory(player);
        if (renderedInventory == null) {
            return;
        }
        RenderedInventory rendered = renderedInventory;
        if (rendered.getMenu().allowsChangingHeldItem()) {
            return;
        }
        if (event.getHotbarButton() == player.getInventory().getHeldItemSlot()) {
            event.setCancelled(true);
        }
        if (event.getClickedInventory() instanceof PlayerInventory) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void temporaryExploitPatch(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (RenderedInventoryKt.getRenderedInventory(GUIHelperExtensions.getPlayer(event)) == null) {
            return;
        }
        if (event.getAction() == InventoryAction.COLLECT_TO_CURSOR) {
            event.setCancelled(true);
        }
    }

    private final void renderActiveMenu(Player $this$renderActiveMenu) {
        RenderedInventory renderedInventory = RenderedInventoryKt.getRenderedInventory($this$renderActiveMenu);
        if (renderedInventory == null) {
            return;
        }
        RenderedInventory rendered = renderedInventory;
        rendered.render();
        this.plugin.getScheduler().run(() -> GUIListener.renderActiveMenu$lambda$1(rendered));
    }

    private static final void handleClose$lambda$0(InventoryCloseEvent $event) {
        Intrinsics.checkNotNullParameter($event, "$event");
        Inventory inventory = $event.getInventory();
        Intrinsics.checkNotNullExpressionValue(inventory, "getInventory(...)");
        MenuHandler.INSTANCE.unregisterInventory(inventory);
    }

    private static final void renderActiveMenu$lambda$1(RenderedInventory $rendered) {
        Intrinsics.checkNotNullParameter($rendered, "$rendered");
        $rendered.render();
    }
}

