/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.antigrief;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.island.Island;
import com.willfp.eco.core.integrations.antigrief.AntigriefIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/antigrief/AntigriefFabledSkyBlock;", "Lcom/willfp/eco/core/integrations/antigrief/AntigriefIntegration;", "()V", "skyblock", "Lcom/craftaro/skyblock/SkyBlock;", "Lcom/willfp/eco/libs/jetbrains/annotations/NotNull;", "canBreakBlock", "", "player", "Lorg/bukkit/entity/Player;", "block", "Lorg/bukkit/block/Block;", "canCreateExplosion", "location", "Lorg/bukkit/Location;", "canInjure", "victim", "Lorg/bukkit/entity/LivingEntity;", "canPickupItem", "canPlaceBlock", "getPluginName", "", "core-plugin"})
public final class AntigriefFabledSkyBlock
implements AntigriefIntegration {
    @NotNull
    private final SkyBlock skyblock;

    public AntigriefFabledSkyBlock() {
        JavaPlugin javaPlugin = JavaPlugin.getPlugin(SkyBlock.class);
        Intrinsics.checkNotNullExpressionValue(javaPlugin, "getPlugin(...)");
        this.skyblock = (SkyBlock)javaPlugin;
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "FabledSkyBlock";
    }

    @Override
    public boolean canBreakBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        Island island = this.skyblock.getIslandManager().getIslandAtLocation(block.getLocation());
        if (island == null) {
            return true;
        }
        Island island2 = island;
        if (player.hasPermission("fabledskyblock.bypass.destroy")) {
            return true;
        }
        return this.skyblock.getPermissionManager().hasPermission(island2, "Destroy", island2.getRole((OfflinePlayer)player));
    }

    @Override
    public boolean canCreateExplosion(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        Island island = this.skyblock.getIslandManager().getIslandAtLocation(location);
        if (island == null) {
            return true;
        }
        Island island2 = island;
        if (player.hasPermission("fabledskyblock.bypass.explosions")) {
            return true;
        }
        return this.skyblock.getPermissionManager().hasPermission(island2, "Explosions", island2.getRole((OfflinePlayer)player));
    }

    @Override
    public boolean canPlaceBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        Island island = this.skyblock.getIslandManager().getIslandAtLocation(block.getLocation());
        if (island == null) {
            return true;
        }
        Island island2 = island;
        if (player.hasPermission("fabledskyblock.bypass.place")) {
            return true;
        }
        return this.skyblock.getPermissionManager().hasPermission(island2, "Place", island2.getRole((OfflinePlayer)player));
    }

    @Override
    public boolean canInjure(@NotNull Player player, @NotNull LivingEntity victim) {
        String islandPermission;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(victim, "victim");
        Island island = this.skyblock.getIslandManager().getIslandAtLocation(victim.getLocation());
        if (island == null) {
            return true;
        }
        Island island2 = island;
        if (victim instanceof Player) {
            return this.skyblock.getPermissionManager().hasPermission(island2, "PvP", island2.getRole((OfflinePlayer)player));
        }
        String string = islandPermission = victim instanceof Monster ? "MonsterHurting" : "MobHurting";
        return this.skyblock.getPermissionManager().hasPermission(island2, islandPermission, island2.getRole((OfflinePlayer)player));
    }

    @Override
    public boolean canPickupItem(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        Island island = this.skyblock.getIslandManager().getIslandAtLocation(location);
        if (island == null) {
            return true;
        }
        Island island2 = island;
        if (player.hasPermission("fabledskyblock.bypass.itempickup")) {
            return true;
        }
        return this.skyblock.getPermissionManager().hasPermission(island2, "ItemPickup", island2.getRole((OfflinePlayer)player));
    }
}

