/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.antigrief;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.perms.PermissibleAction;
import com.massivecraft.factions.perms.PermissibleActions;
import com.massivecraft.factions.perms.Selectable;
import com.willfp.eco.core.integrations.antigrief.AntigriefIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/antigrief/AntigriefFactionsUUID;", "Lcom/willfp/eco/core/integrations/antigrief/AntigriefIntegration;", "()V", "canBreakBlock", "", "player", "Lorg/bukkit/entity/Player;", "block", "Lorg/bukkit/block/Block;", "canCreateExplosion", "location", "Lorg/bukkit/Location;", "canInjure", "victim", "Lorg/bukkit/entity/LivingEntity;", "canPickupItem", "canPlaceBlock", "equals", "other", "", "getPluginName", "", "hashCode", "", "core-plugin"})
public final class AntigriefFactionsUUID
implements AntigriefIntegration {
    @Override
    public boolean canBreakBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        FPlayer fPlayer = FPlayers.getInstance().getByPlayer(player);
        Intrinsics.checkNotNullExpressionValue(fPlayer, "getByPlayer(...)");
        FPlayer fplayer = fPlayer;
        FLocation flocation = new FLocation(block.getLocation());
        Faction faction = Board.getInstance().getFactionAt(flocation);
        Intrinsics.checkNotNullExpressionValue(faction, "getFactionAt(...)");
        Faction faction2 = faction;
        return !faction2.hasAccess((Selectable)fplayer, (PermissibleAction)PermissibleActions.DESTROY, flocation) ? fplayer.isAdminBypassing() : true;
    }

    @Override
    public boolean canCreateExplosion(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        FLocation flocation = new FLocation(location);
        Faction faction = Board.getInstance().getFactionAt(flocation);
        Intrinsics.checkNotNullExpressionValue(faction, "getFactionAt(...)");
        Faction faction2 = faction;
        return !faction2.noExplosionsInTerritory();
    }

    @Override
    public boolean canPlaceBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        FPlayer fPlayer = FPlayers.getInstance().getByPlayer(player);
        Intrinsics.checkNotNullExpressionValue(fPlayer, "getByPlayer(...)");
        FPlayer fplayer = fPlayer;
        FLocation flocation = new FLocation(block.getLocation());
        Faction faction = Board.getInstance().getFactionAt(flocation);
        Intrinsics.checkNotNullExpressionValue(faction, "getFactionAt(...)");
        Faction faction2 = faction;
        return !faction2.hasAccess((Selectable)fplayer, (PermissibleAction)PermissibleActions.BUILD, flocation) ? fplayer.isAdminBypassing() : true;
    }

    @Override
    public boolean canInjure(@NotNull Player player, @NotNull LivingEntity victim) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(victim, "victim");
        FPlayer fPlayer = FPlayers.getInstance().getByPlayer(player);
        Intrinsics.checkNotNullExpressionValue(fPlayer, "getByPlayer(...)");
        FPlayer fplayer = fPlayer;
        FLocation flocation = new FLocation(victim.getLocation());
        Faction faction = Board.getInstance().getFactionAt(flocation);
        Intrinsics.checkNotNullExpressionValue(faction, "getFactionAt(...)");
        Faction faction2 = faction;
        if (victim instanceof Player ? faction2.isPeaceful() : faction2.hasAccess((Selectable)fplayer, (PermissibleAction)PermissibleActions.DESTROY, flocation)) {
            return fplayer.isAdminBypassing();
        }
        return true;
    }

    @Override
    public boolean canPickupItem(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        return true;
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "FactionsUUID";
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof AntigriefIntegration)) {
            return false;
        }
        return Intrinsics.areEqual(((AntigriefIntegration)other).getPluginName(), this.getPluginName());
    }

    public int hashCode() {
        return this.getPluginName().hashCode();
    }
}

