/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.antigrief;

import com.willfp.eco.core.integrations.antigrief.AntigriefIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.william278.huskclaims.api.HuskClaimsAPI;
import net.william278.huskclaims.libraries.cloplib.operation.Operation;
import net.william278.huskclaims.libraries.cloplib.operation.OperationPosition;
import net.william278.huskclaims.libraries.cloplib.operation.OperationType;
import net.william278.huskclaims.libraries.cloplib.operation.OperationUser;
import net.william278.huskclaims.position.Position;
import net.william278.huskclaims.position.World;
import net.william278.huskclaims.user.OnlineUser;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/antigrief/AntigriefHuskClaims;", "Lcom/willfp/eco/core/integrations/antigrief/AntigriefIntegration;", "()V", "canBreakBlock", "", "player", "Lorg/bukkit/entity/Player;", "block", "Lorg/bukkit/block/Block;", "canCreateExplosion", "location", "Lorg/bukkit/Location;", "canInjure", "victim", "Lorg/bukkit/entity/LivingEntity;", "canPickupItem", "canPlaceBlock", "equals", "other", "", "getPluginName", "", "hashCode", "", "core-plugin"})
public final class AntigriefHuskClaims
implements AntigriefIntegration {
    @Override
    public boolean canBreakBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        HuskClaimsAPI huskClaimsAPI = HuskClaimsAPI.getInstance();
        if (huskClaimsAPI == null) {
            return true;
        }
        HuskClaimsAPI api = huskClaimsAPI;
        OnlineUser onlineUser = api.getOnlineUser(player.getUniqueId());
        if (onlineUser == null) {
            return true;
        }
        OnlineUser user = onlineUser;
        return api.isOperationAllowed(Operation.of((OperationUser)((OperationUser)user), (OperationType)OperationType.BLOCK_BREAK, (OperationPosition)((OperationPosition)Position.at((double)block.getX(), (double)block.getY(), (double)block.getZ(), (World)api.getWorld(block.getLocation().getWorld().getName()))), (boolean)true));
    }

    @Override
    public boolean canCreateExplosion(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        HuskClaimsAPI huskClaimsAPI = HuskClaimsAPI.getInstance();
        if (huskClaimsAPI == null) {
            return true;
        }
        HuskClaimsAPI api = huskClaimsAPI;
        OnlineUser onlineUser = api.getOnlineUser(player.getUniqueId());
        if (onlineUser == null) {
            return true;
        }
        OnlineUser user = onlineUser;
        return api.isOperationAllowed(Operation.of((OperationUser)((OperationUser)user), (OperationType)OperationType.EXPLOSION_DAMAGE_ENTITY, (OperationPosition)((OperationPosition)Position.at((double)location.getX(), (double)location.getY(), (double)location.getZ(), (World)api.getWorld(location.getWorld().getName()))), (boolean)true));
    }

    @Override
    public boolean canPlaceBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        HuskClaimsAPI huskClaimsAPI = HuskClaimsAPI.getInstance();
        if (huskClaimsAPI == null) {
            return true;
        }
        HuskClaimsAPI api = huskClaimsAPI;
        OnlineUser onlineUser = api.getOnlineUser(player.getUniqueId());
        if (onlineUser == null) {
            return true;
        }
        OnlineUser user = onlineUser;
        return api.isOperationAllowed(Operation.of((OperationUser)((OperationUser)user), (OperationType)OperationType.BLOCK_PLACE, (OperationPosition)((OperationPosition)Position.at((double)block.getX(), (double)block.getY(), (double)block.getZ(), (World)api.getWorld(block.getLocation().getWorld().getName()))), (boolean)true));
    }

    @Override
    public boolean canInjure(@NotNull Player player, @NotNull LivingEntity victim) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(victim, "victim");
        HuskClaimsAPI huskClaimsAPI = HuskClaimsAPI.getInstance();
        if (huskClaimsAPI == null) {
            return true;
        }
        HuskClaimsAPI api = huskClaimsAPI;
        OnlineUser onlineUser = api.getOnlineUser(player.getUniqueId());
        if (onlineUser == null) {
            return true;
        }
        OnlineUser user = onlineUser;
        LivingEntity livingEntity = victim;
        return api.isOperationAllowed(Operation.of((OperationUser)((OperationUser)user), (OperationType)(livingEntity instanceof Monster ? OperationType.PLAYER_DAMAGE_MONSTER : (livingEntity instanceof Player ? OperationType.PLAYER_DAMAGE_PLAYER : OperationType.PLAYER_DAMAGE_ENTITY)), (OperationPosition)((OperationPosition)Position.at((double)victim.getX(), (double)victim.getY(), (double)victim.getZ(), (World)api.getWorld(victim.getLocation().getWorld().getName()))), (boolean)true));
    }

    @Override
    public boolean canPickupItem(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        return true;
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "HuskClaims";
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof AntigriefIntegration)) {
            return false;
        }
        return Intrinsics.areEqual(((AntigriefIntegration)other).getPluginName(), this.getPluginName());
    }

    public int hashCode() {
        return this.getPluginName().hashCode();
    }
}

