/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.antigrief;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.willfp.eco.core.integrations.antigrief.AntigriefIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/antigrief/AntigriefTowny;", "Lcom/willfp/eco/core/integrations/antigrief/AntigriefIntegration;", "()V", "canBreakBlock", "", "player", "Lorg/bukkit/entity/Player;", "block", "Lorg/bukkit/block/Block;", "canCreateExplosion", "location", "Lorg/bukkit/Location;", "canInjure", "victim", "Lorg/bukkit/entity/LivingEntity;", "canPickupItem", "canPlaceBlock", "equals", "other", "", "getPluginName", "", "hashCode", "", "core-plugin"})
public final class AntigriefTowny
implements AntigriefIntegration {
    @Override
    public boolean canBreakBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        Map map2 = TownyUniverse.getInstance().getWorldMap();
        World world = block.getLocation().getWorld();
        Intrinsics.checkNotNull(world);
        if ((TownyWorld)map2.get(world.getName()) == null) {
            return true;
        }
        return TownyAPI.getInstance().isWilderness(block) ? true : PlayerCacheUtil.getCachePermission((Player)player, (Location)block.getLocation(), (Material)block.getType(), (TownyPermission.ActionType)TownyPermission.ActionType.DESTROY) || PlayerCacheUtil.getCachePermission((Player)player, (Location)block.getLocation(), (Material)block.getType(), (TownyPermission.ActionType)TownyPermission.ActionType.BUILD);
    }

    @Override
    public boolean canCreateExplosion(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        World world = location.getWorld();
        if ((TownyWorld)TownyUniverse.getInstance().getWorldMap().get(world != null ? world.getName() : null) == null) {
            return true;
        }
        return TownyAPI.getInstance().isWilderness(location) ? true : PlayerCacheUtil.getCachePermission((Player)player, (Location)location, (Material)Material.TNT, (TownyPermission.ActionType)TownyPermission.ActionType.ITEM_USE);
    }

    @Override
    public boolean canPlaceBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        World world = block.getLocation().getWorld();
        if ((TownyWorld)TownyUniverse.getInstance().getWorldMap().get(world != null ? world.getName() : null) == null) {
            return true;
        }
        return TownyAPI.getInstance().isWilderness(block) ? true : PlayerCacheUtil.getCachePermission((Player)player, (Location)block.getLocation(), (Material)block.getType(), (TownyPermission.ActionType)TownyPermission.ActionType.BUILD);
    }

    @Override
    public boolean canInjure(@NotNull Player player, @NotNull LivingEntity victim) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(victim, "victim");
        World world = victim.getLocation().getWorld();
        TownyWorld townyWorld = (TownyWorld)TownyUniverse.getInstance().getWorldMap().get(world != null ? world.getName() : null);
        if (townyWorld == null) {
            return true;
        }
        TownyWorld world2 = townyWorld;
        if (TownyAPI.getInstance().isWilderness(victim.getLocation())) {
            return victim instanceof Player ? world2.isPVP() : true;
        }
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(victim.getLocation());
        if (townBlock == null) {
            return true;
        }
        TownBlock townBlock2 = townBlock;
        return townBlock2.getPermissions().pvp;
    }

    @Override
    public boolean canPickupItem(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        return true;
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "Towny";
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof AntigriefIntegration)) {
            return false;
        }
        return Intrinsics.areEqual(((AntigriefIntegration)other).getPluginName(), this.getPluginName());
    }

    public int hashCode() {
        return this.getPluginName().hashCode();
    }
}

