/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.economy;

import com.willfp.eco.core.integrations.economy.EconomyIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/economy/EconomyVault;", "Lcom/willfp/eco/core/integrations/economy/EconomyIntegration;", "vault", "Lnet/milkbowl/vault/economy/Economy;", "(Lnet/milkbowl/vault/economy/Economy;)V", "getExactBalance", "Ljava/math/BigDecimal;", "player", "Lorg/bukkit/OfflinePlayer;", "getPluginName", "", "giveMoney", "", "amount", "hasAmount", "removeMoney", "core-plugin"})
public final class EconomyVault
implements EconomyIntegration {
    @NotNull
    private final Economy vault;

    public EconomyVault(@NotNull Economy vault) {
        Intrinsics.checkNotNullParameter(vault, "vault");
        this.vault = vault;
    }

    @Override
    public boolean hasAmount(@NotNull OfflinePlayer player, @NotNull BigDecimal amount) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(amount, "amount");
        return this.vault.has(player, amount.doubleValue());
    }

    @Override
    public boolean giveMoney(@NotNull OfflinePlayer player, @NotNull BigDecimal amount) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(amount, "amount");
        return this.vault.depositPlayer(player, amount.doubleValue()).transactionSuccess();
    }

    @Override
    public boolean removeMoney(@NotNull OfflinePlayer player, @NotNull BigDecimal amount) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(amount, "amount");
        return this.vault.withdrawPlayer(player, amount.doubleValue()).transactionSuccess();
    }

    @Override
    @NotNull
    public BigDecimal getExactBalance(@NotNull OfflinePlayer player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return new BigDecimal(String.valueOf(this.vault.getBalance(player)));
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "Vault";
    }
}

