/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.mcmmo;

import com.gmail.nossr50.datatypes.meta.BonusDropMeta;
import com.gmail.nossr50.events.fake.FakeEvent;
import com.willfp.eco.core.integrations.mcmmo.McmmoIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.ClassUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/mcmmo/McmmoIntegrationImpl;", "Lcom/willfp/eco/core/integrations/mcmmo/McmmoIntegration;", "()V", "disabled", "", "getBonusDropCount", "", "block", "Lorg/bukkit/block/Block;", "getPluginName", "", "isFake", "event", "Lorg/bukkit/event/Event;", "core-plugin"})
public final class McmmoIntegrationImpl
implements McmmoIntegration {
    private boolean disabled;

    public McmmoIntegrationImpl() {
        if (!ClassUtils.exists("com.gmail.nossr50.events.fake.FakeEvent")) {
            this.disabled = true;
        }
    }

    @Override
    public int getBonusDropCount(@NotNull Block block) {
        Intrinsics.checkNotNullParameter(block, "block");
        if (this.disabled) {
            return 0;
        }
        if (block.getMetadata("mcMMO: Double Drops").size() > 0) {
            Object e = block.getMetadata("mcMMO: Double Drops").get(0);
            Intrinsics.checkNotNull(e, "null cannot be cast to non-null type com.gmail.nossr50.datatypes.meta.BonusDropMeta");
            BonusDropMeta bonusDropMeta = (BonusDropMeta)e;
            return bonusDropMeta.asInt();
        }
        return 0;
    }

    @Override
    public boolean isFake(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        return this.disabled ? false : event instanceof FakeEvent;
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "mcMMO";
    }
}

