/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage;

import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.Context;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.Token;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.TokenParser;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.TokenType;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node.ElementNode;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node.TagNode;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node.ValueNode;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.template.TemplateResolver;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.Modifying;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.Transformation;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.TransformationRegistry;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.kyori.adventure.text.Component;

final class MiniMessageParser {
    final TransformationRegistry registry;
    final TemplateResolver templateResolver;

    MiniMessageParser() {
        this.registry = TransformationRegistry.standard();
        this.templateResolver = TemplateResolver.empty();
    }

    MiniMessageParser(TransformationRegistry registry, TemplateResolver templateResolver) {
        this.registry = registry;
        this.templateResolver = templateResolver;
    }

    @NotNull
    String escapeTokens(@NotNull String richMessage, @NotNull Context context) {
        StringBuilder sb = new StringBuilder(richMessage.length());
        this.escapeTokens(sb, richMessage, context);
        return sb.toString();
    }

    void escapeTokens(StringBuilder sb, @NotNull String richMessage, @NotNull Context context) {
        this.processTokens(sb, richMessage, context, (token2, builder) -> {
            builder.append('\\').append('<');
            if (token2.type() == TokenType.CLOSE_TAG) {
                builder.append('/');
            }
            List<Token> childTokens = token2.childTokens();
            for (int i = 0; i < childTokens.size(); ++i) {
                if (i != 0) {
                    builder.append(':');
                }
                this.escapeTokens((StringBuilder)builder, childTokens.get(i).get(richMessage).toString(), context);
            }
            builder.append('>');
        });
    }

    @NotNull
    String stripTokens(@NotNull String richMessage, @NotNull Context context) {
        StringBuilder sb = new StringBuilder(richMessage.length());
        this.processTokens(sb, richMessage, context, (token2, builder) -> {});
        return sb.toString();
    }

    private void processTokens(@NotNull StringBuilder sb, @NotNull String richMessage, @NotNull Context context, BiConsumer<Token, StringBuilder> tagHandler) {
        TemplateResolver combinedResolver = TemplateResolver.combining(context.templateResolver(), this.templateResolver);
        List<Token> root = TokenParser.tokenize(richMessage);
        block4: for (Token token2 : root) {
            switch (token2.type()) {
                case TEXT: {
                    sb.append(richMessage, token2.startIndex(), token2.endIndex());
                    continue block4;
                }
                case OPEN_TAG: 
                case CLOSE_TAG: {
                    if (token2.childTokens().isEmpty()) {
                        sb.append(richMessage, token2.startIndex(), token2.endIndex());
                        continue block4;
                    }
                    String sanitized = this.sanitizeTemplateName(token2.childTokens().get(0).get(richMessage).toString());
                    if (this.registry.exists(sanitized, combinedResolver) || combinedResolver.canResolve(sanitized)) {
                        tagHandler.accept(token2, sb);
                        continue block4;
                    }
                    sb.append(richMessage, token2.startIndex(), token2.endIndex());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unsupported token type " + (Object)((Object)token2.type()));
        }
    }

    @NotNull
    Component parseFormat(@NotNull String richMessage, @NotNull Context context) {
        TemplateResolver combinedResolver = TemplateResolver.combining(context.templateResolver(), this.templateResolver);
        Appendable debug = context.debugOutput();
        if (debug != null) {
            try {
                debug.append("Beginning parsing message ").append(richMessage).append('\n');
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Function<TagNode, Transformation> transformationFactory = debug != null ? node -> {
            try {
                try {
                    debug.append("Attempting to match node '").append(node.name()).append("' at column ").append(String.valueOf(node.token().startIndex())).append('\n');
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Transformation transformation = this.registry.get(this.sanitizeTemplateName(node.name()), node.parts(), combinedResolver, context);
                try {
                    if (transformation == null) {
                        debug.append("Could not match node '").append(node.name()).append("'\n");
                    } else {
                        debug.append("Successfully matched node '").append(node.name()).append("' to transformation ").append(transformation.examinableName()).append('\n');
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return transformation;
            }
            catch (ParsingException e) {
                try {
                    if (e.tokens().length == 0) {
                        e.tokens(new Token[]{node.token()});
                    }
                    debug.append("Could not match node '").append(node.name()).append("' - ").append(e.getMessage()).append('\n');
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        } : node -> {
            try {
                return this.registry.get(this.sanitizeTemplateName(node.name()), node.parts(), combinedResolver, context);
            }
            catch (ParsingException ignored) {
                return null;
            }
        };
        BiPredicate<String, Boolean> tagNameChecker = (name, includeTemplates) -> {
            String sanitized = this.sanitizeTemplateName((String)name);
            return this.registry.exists(sanitized, combinedResolver) || includeTemplates != false && combinedResolver.canResolve((String)name);
        };
        ElementNode root = TokenParser.parse(transformationFactory, tagNameChecker, combinedResolver, richMessage, context.strict());
        if (debug != null) {
            try {
                debug.append("Text parsed into element tree:\n");
                debug.append(root.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        context.root(root);
        return Objects.requireNonNull((Component)context.postProcessor().apply(this.treeToComponent(root)), "Post-processor must not return null");
    }

    @NotNull
    Component treeToComponent(@NotNull ElementNode node) {
        Component comp;
        Transformation transformation = null;
        if (node instanceof ValueNode) {
            comp = Component.text(((ValueNode)node).value());
        } else if (node instanceof TagNode) {
            TagNode tag = (TagNode)node;
            transformation = tag.transformation();
            if (transformation instanceof Modifying) {
                Modifying modTransformation = (Modifying)((Object)transformation);
                LinkedList<ElementNode> toVisit = new LinkedList<ElementNode>(node.children());
                while (!toVisit.isEmpty()) {
                    ElementNode curr = toVisit.removeFirst();
                    modTransformation.visit(curr);
                    toVisit.addAll(0, curr.children());
                }
            }
            comp = transformation.apply();
        } else {
            comp = Component.empty();
        }
        for (ElementNode child : node.children()) {
            comp = comp.append(this.treeToComponent(child));
        }
        if (transformation instanceof Modifying) {
            comp = this.handleModifying((Modifying)((Object)transformation), comp, 0);
        }
        return comp;
    }

    private Component handleModifying(Modifying modTransformation, Component current, int depth) {
        Component newComp = modTransformation.apply(current, depth);
        for (Component child : current.children()) {
            newComp = newComp.append(this.handleModifying(modTransformation, child, depth + 1));
        }
        return newComp;
    }

    private String sanitizeTemplateName(String name) {
        return name.toLowerCase(Locale.ROOT);
    }
}

