/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation;

import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.Context;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.Template;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node.TagPart;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.template.TemplateResolver;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.Transformation;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.TransformationFactory;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.TransformationRegistry;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.TransformationType;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.inbuild.TemplateTransformation;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class TransformationRegistryImpl
implements TransformationRegistry {
    private static final List<TransformationType<? extends Transformation>> DEFAULT_TRANSFORMATIONS = new ArrayList<TransformationType<? extends Transformation>>();
    static final TransformationRegistry EMPTY;
    static final TransformationRegistry STANDARD;
    private final List<TransformationType<? extends Transformation>> types;

    TransformationRegistryImpl(List<TransformationType<? extends Transformation>> types) {
        this.types = Collections.unmodifiableList(types);
    }

    private Transformation tryLoad(TransformationFactory<?> factory, String name, List<TagPart> inners, Context context) {
        try {
            Object xform = factory.parse(context, name, inners.subList(1, inners.size()));
            ((Transformation)xform).context(context);
            ((Transformation)xform).load(name, inners.subList(1, inners.size()));
            return xform;
        }
        catch (ParsingException exception) {
            exception.originalText(context.originalMessage());
            throw exception;
        }
    }

    @Override
    @Nullable
    public Transformation get(String name, List<TagPart> inners, TemplateResolver templateResolver, Context context) {
        Template template = templateResolver.resolve(name);
        if (template != null && template instanceof Template.ComponentTemplate) {
            return this.tryLoad(TemplateTransformation.factory(new Template.ComponentTemplate(name, ((Template.ComponentTemplate)template).value())), name, inners, context);
        }
        for (TransformationType<? extends Transformation> type2 : this.types) {
            if (!type2.canParse.test(name)) continue;
            return this.tryLoad(type2.factory, name, inners, context);
        }
        return null;
    }

    @Override
    public boolean exists(String name, TemplateResolver templateResolver) {
        if (templateResolver.canResolve(name)) {
            return true;
        }
        for (TransformationType<? extends Transformation> type2 : this.types) {
            if (!type2.canParse.test(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public TransformationRegistry.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static {
        DEFAULT_TRANSFORMATIONS.add(TransformationType.COLOR);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.DECORATION);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.HOVER_EVENT);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.CLICK_EVENT);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.KEYBIND);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.TRANSLATABLE);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.INSERTION);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.FONT);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.GRADIENT);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.RAINBOW);
        EMPTY = new TransformationRegistryImpl(Collections.emptyList());
        STANDARD = (TransformationRegistry)TransformationRegistry.builder().build();
    }

    static final class BuilderImpl
    implements TransformationRegistry.Builder {
        private final List<TransformationType<? extends Transformation>> types;

        BuilderImpl() {
            this.types = new ArrayList<TransformationType<? extends Transformation>>(DEFAULT_TRANSFORMATIONS);
        }

        BuilderImpl(TransformationRegistryImpl registry) {
            this.types = new ArrayList<TransformationType<? extends Transformation>>(registry.types);
        }

        @Override
        @NotNull
        public TransformationRegistry.Builder clear() {
            this.types.clear();
            return this;
        }

        @Override
        @NotNull
        public TransformationRegistry.Builder add(@NotNull TransformationType<? extends Transformation> transformation) {
            this.types.add(transformation);
            return this;
        }

        @Override
        @SafeVarargs
        @NotNull
        public final TransformationRegistry.Builder add(TransformationType<? extends Transformation> ... transformations) {
            Collections.addAll(this.types, transformations);
            return this;
        }

        @Override
        @NotNull
        public TransformationRegistry build() {
            return new TransformationRegistryImpl(this.types);
        }
    }
}

