/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_18_R1.common.packet;

import com.willfp.eco.core.packet.Packet;
import com.willfp.eco.core.packet.PacketEvent;
import com.willfp.eco.internal.events.EcoEventManagerKt;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/willfp/eco/internal/spigot/proxy/v1_18_R1/common/packet/EcoChannelDuplexHandler;", "Lio/netty/channel/ChannelDuplexHandler;", "uuid", "Ljava/util/UUID;", "(Ljava/util/UUID;)V", "channelRead", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "", "write", "promise", "Lio/netty/channel/ChannelPromise;", "nms-common"})
public final class EcoChannelDuplexHandler
extends ChannelDuplexHandler {
    @NotNull
    private final UUID uuid;

    public EcoChannelDuplexHandler(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        this.uuid = uuid;
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(msg, "msg");
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        if (player != null) {
            PacketEvent event = new PacketEvent(new Packet(msg), player);
            EcoEventManagerKt.handleReceive(event);
            if (!event.isCancelled()) {
                super.channelRead(ctx, msg);
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(promise, "promise");
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        if (player != null) {
            PacketEvent event = new PacketEvent(new Packet(msg), player);
            EcoEventManagerKt.handleSend(event);
            if (!event.isCancelled()) {
                super.write(ctx, msg, promise);
            }
        } else {
            super.write(ctx, msg, promise);
        }
    }
}

