/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser;

import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.Token;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.node.TagPart;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Arrays;
import java.util.List;

public class ParsingException
extends RuntimeException {
    private static final long serialVersionUID = 2507190809441787201L;
    @Nullable
    private String originalText;
    private Token @NotNull [] tokens;

    public ParsingException(String message, @Nullable String originalText, @NotNull List<TagPart> tags) {
        this(message, originalText, ParsingException.tagsToTokens(tags));
    }

    public ParsingException(String message, @Nullable String originalText, Token ... tokens) {
        super(message);
        this.tokens = tokens;
        this.originalText = originalText;
    }

    public ParsingException(String message, @Nullable String originalText, @Nullable Throwable cause, @NotNull List<TagPart> tags) {
        this(message, originalText, cause, ParsingException.tagsToTokens(tags));
    }

    public ParsingException(String message, @Nullable String originalText, @Nullable Throwable cause, Token ... tokens) {
        super(message, cause);
        this.tokens = tokens;
        this.originalText = originalText;
    }

    public ParsingException(String message, List<TagPart> tokens) {
        this(message, ParsingException.tagsToTokens(tokens));
    }

    public ParsingException(String message, Token ... tokens) {
        this(message, (String)null, (Throwable)null, tokens);
    }

    public ParsingException(String message, @Nullable Throwable cause, @NotNull List<TagPart> tags) {
        this(message, null, cause, ParsingException.tagsToTokens(tags));
    }

    public ParsingException(String message, @Nullable Throwable cause, Token ... tokens) {
        this(message, null, cause, tokens);
    }

    @Override
    public String getMessage() {
        String arrowInfo = this.tokens().length != 0 ? "\n\t" + this.arrow() : "";
        String messageInfo = this.originalText() != null ? "\n\t" + this.originalText() + arrowInfo : "";
        return super.getMessage() + messageInfo;
    }

    @Nullable
    public String originalText() {
        return this.originalText;
    }

    public void originalText(@NotNull String originalText) {
        this.originalText = originalText;
    }

    @NotNull
    public @NotNull Token @NotNull [] tokens() {
        return this.tokens;
    }

    public void tokens(@NotNull @NotNull Token @NotNull [] tokens) {
        this.tokens = tokens;
    }

    private String arrow() {
        @NotNull Token[] ts = this.tokens();
        char[] chars = new char[ts[ts.length - 1].endIndex()];
        int i = 0;
        for (Token t2 : ts) {
            Arrays.fill(chars, i, t2.startIndex(), ' ');
            chars[t2.startIndex()] = 94;
            Arrays.fill(chars, t2.startIndex() + 1, t2.endIndex() - 1, '~');
            chars[t2.endIndex() - 1] = 94;
            i = t2.endIndex();
        }
        return new String(chars);
    }

    private static Token[] tagsToTokens(List<TagPart> tags) {
        Token[] tokens = new Token[tags.size()];
        int length = tokens.length;
        for (int i = 0; i < length; ++i) {
            tokens[i] = tags.get(i).token();
        }
        return tokens;
    }
}

