/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_18_R2.minimessage.internal;

import com.willfp.eco.libs.jetbrains.annotations.ApiStatus;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;

@ApiStatus.Internal
public final class TagInternals {
    private static final Pattern TAG_NAME_PATTERN = Pattern.compile("[!?#]?[a-z0-9_-]*");

    private TagInternals() {
    }

    public static void checkTagName(@NotNull String tagName) {
        if (!TAG_NAME_PATTERN.matcher(Objects.requireNonNull(tagName)).matches()) {
            throw new IllegalArgumentException("Tag name must match pattern " + TAG_NAME_PATTERN.pattern() + ", was " + tagName);
        }
    }

    public static void sanitizeAndCheckTagName(@NotNull String tagName) {
        TagInternals.checkTagName(Objects.requireNonNull(tagName).toLowerCase(Locale.ROOT));
    }
}

