/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.tag.resolver;

import com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.Context;
import com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.internal.serializer.ClaimConsumer;
import com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.internal.serializer.SerializableResolver;
import com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.tag.Tag;
import com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.tag.resolver.ArgumentQueue;
import com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.tag.resolver.TagResolver;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Arrays;
import net.kyori.adventure.text.Component;

final class SequentialTagResolver
implements TagResolver,
SerializableResolver {
    final TagResolver[] resolvers;

    SequentialTagResolver(@NotNull @NotNull TagResolver @NotNull [] resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    @Nullable
    public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments2, @NotNull Context ctx) throws ParsingException {
        ParsingException thrown = null;
        for (TagResolver resolver : this.resolvers) {
            try {
                @Nullable Tag placeholder2 = resolver.resolve(name, arguments2, ctx);
                if (placeholder2 == null) continue;
                return placeholder2;
            }
            catch (ParsingException ex) {
                arguments2.reset();
                if (thrown == null) {
                    thrown = ex;
                    continue;
                }
                thrown.addSuppressed(ex);
            }
            catch (Exception ex) {
                arguments2.reset();
                ParsingException err = ctx.newException("Exception thrown while parsing <" + name + ">", ex, arguments2);
                if (thrown == null) {
                    thrown = err;
                    continue;
                }
                thrown.addSuppressed(err);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
        return null;
    }

    @Override
    public boolean has(@NotNull String name) {
        for (TagResolver resolver : this.resolvers) {
            if (!resolver.has(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handle(@NotNull Component serializable, @NotNull ClaimConsumer consumer) {
        for (TagResolver resolver : this.resolvers) {
            if (!(resolver instanceof SerializableResolver)) continue;
            ((SerializableResolver)((Object)resolver)).handle(serializable, consumer);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SequentialTagResolver)) {
            return false;
        }
        SequentialTagResolver that = (SequentialTagResolver)other;
        return Arrays.equals(this.resolvers, that.resolvers);
    }

    public int hashCode() {
        return Arrays.hashCode(this.resolvers);
    }
}

