/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_19_R3.minimessage.tag.standard;

import com.willfp.eco.internal.spigot.proxy.v1_19_R3.minimessage.Context;
import com.willfp.eco.internal.spigot.proxy.v1_19_R3.minimessage.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_19_R3.minimessage.internal.serializer.SerializableResolver;
import com.willfp.eco.internal.spigot.proxy.v1_19_R3.minimessage.internal.serializer.StyleClaim;
import com.willfp.eco.internal.spigot.proxy.v1_19_R3.minimessage.internal.serializer.TokenEmitter;
import com.willfp.eco.internal.spigot.proxy.v1_19_R3.minimessage.tag.Tag;
import com.willfp.eco.internal.spigot.proxy.v1_19_R3.minimessage.tag.resolver.ArgumentQueue;
import com.willfp.eco.internal.spigot.proxy.v1_19_R3.minimessage.tag.resolver.TagResolver;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.UUID;
import net.kyori.adventure.key.InvalidKeyException;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.Style;

final class HoverTag {
    private static final String HOVER = "hover";
    static final TagResolver RESOLVER = SerializableResolver.claimingStyle("hover", HoverTag::create, StyleClaim.claim("hover", Style::hoverEvent, HoverTag::emit));

    private HoverTag() {
    }

    static Tag create(ArgumentQueue args2, Context ctx) throws ParsingException {
        String actionName = args2.popOr("Hover event requires an action as its first argument").value();
        HoverEvent.Action<?> action = HoverEvent.Action.NAMES.value(actionName);
        ActionHandler<?> value = HoverTag.actionHandler(action);
        if (value == null) {
            throw ctx.newException("Don't know how to turn '" + args2 + "' into a hover event", args2);
        }
        return Tag.styling(HoverEvent.hoverEvent(action, value.parse(args2, ctx)));
    }

    static void emit(HoverEvent<?> event, TokenEmitter emitter) {
        ActionHandler<?> handler = HoverTag.actionHandler(event.action());
        emitter.tag(HOVER).argument(HoverEvent.Action.NAMES.key(event.action()));
        handler.emit(event.value(), emitter);
    }

    @Nullable
    static <V> ActionHandler<V> actionHandler(HoverEvent.Action<V> action) {
        ActionHandler<Component> ret = null;
        if (action == HoverEvent.Action.SHOW_TEXT) {
            ret = ShowText.INSTANCE;
        } else if (action == HoverEvent.Action.SHOW_ITEM) {
            ret = ShowItem.INSTANCE;
        } else if (action == HoverEvent.Action.SHOW_ENTITY) {
            ret = ShowEntity.INSTANCE;
        }
        return ret;
    }

    @NotNull
    static String compactAsString(@NotNull Key key) {
        if (key.namespace().equals("minecraft")) {
            return key.value();
        }
        return key.asString();
    }

    static final class ShowEntity
    implements ActionHandler<HoverEvent.ShowEntity> {
        static final ShowEntity INSTANCE = new ShowEntity();

        private ShowEntity() {
        }

        @Override
        public @NotNull HoverEvent.ShowEntity parse(@NotNull ArgumentQueue args2, @NotNull Context ctx) throws ParsingException {
            try {
                Key key = Key.key(args2.popOr("Show entity needs a type argument").value());
                UUID id2 = UUID.fromString(args2.popOr("Show entity needs an entity UUID").value());
                if (args2.hasNext()) {
                    Component name = ctx.deserialize(args2.pop().value());
                    return HoverEvent.ShowEntity.of(key, id2, name);
                }
                return HoverEvent.ShowEntity.of(key, id2);
            }
            catch (IllegalArgumentException | InvalidKeyException ex) {
                throw ctx.newException("Exception parsing show_entity hover", ex, args2);
            }
        }

        @Override
        public void emit(HoverEvent.ShowEntity event, TokenEmitter emit2) {
            emit2.argument(HoverTag.compactAsString(event.type())).argument(event.id().toString());
            if (event.name() != null) {
                emit2.argument(event.name());
            }
        }
    }

    static final class ShowItem
    implements ActionHandler<HoverEvent.ShowItem> {
        private static final ShowItem INSTANCE = new ShowItem();

        private ShowItem() {
        }

        @Override
        public @NotNull HoverEvent.ShowItem parse(@NotNull ArgumentQueue args2, @NotNull Context ctx) throws ParsingException {
            try {
                int count2;
                Key key = Key.key(args2.popOr("Show item hover needs at least an item ID").value());
                int n = count2 = args2.hasNext() ? args2.pop().asInt().orElseThrow(() -> ctx.newException("The count argument was not a valid integer")) : 1;
                if (args2.hasNext()) {
                    return HoverEvent.ShowItem.of(key, count2, BinaryTagHolder.binaryTagHolder(args2.pop().value()));
                }
                return HoverEvent.ShowItem.of(key, count2);
            }
            catch (NumberFormatException | InvalidKeyException ex) {
                throw ctx.newException("Exception parsing show_item hover", ex, args2);
            }
        }

        @Override
        public void emit(HoverEvent.ShowItem event, TokenEmitter emit2) {
            emit2.argument(HoverTag.compactAsString(event.item()));
            if (event.count() != 1 || event.nbt() != null) {
                emit2.argument(Integer.toString(event.count()));
                if (event.nbt() != null) {
                    emit2.argument(event.nbt().string());
                }
            }
        }
    }

    static final class ShowText
    implements ActionHandler<Component> {
        private static final ShowText INSTANCE = new ShowText();

        private ShowText() {
        }

        @Override
        @NotNull
        public Component parse(@NotNull ArgumentQueue args2, @NotNull Context ctx) throws ParsingException {
            return ctx.deserialize(args2.popOr("show_text action requires a message").value());
        }

        @Override
        public void emit(Component event, TokenEmitter emit2) {
            emit2.argument(event);
        }
    }

    static interface ActionHandler<V> {
        @NotNull
        public V parse(@NotNull ArgumentQueue var1, @NotNull Context var2) throws ParsingException;

        public void emit(V var1, TokenEmitter var2);
    }
}

