/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.recipes;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.items.ItemsExtensions;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.core.recipe.Recipes;
import com.willfp.eco.core.recipe.parts.GroupedTestableItems;
import com.willfp.eco.core.recipe.parts.TestableStack;
import com.willfp.eco.core.recipe.recipes.CraftingRecipe;
import com.willfp.eco.internal.spigot.recipes.StackedRecipeHandler;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0016\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/willfp/eco/internal/spigot/recipes/StackedRecipeListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "handleStacks", "", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "runTwice", "block", "Lkotlin/Function0;", "Companion", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nStackedRecipeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackedRecipeListener.kt\ncom/willfp/eco/internal/spigot/recipes/StackedRecipeListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n288#2,2:156\n*S KotlinDebug\n*F\n+ 1 StackedRecipeListener.kt\ncom/willfp/eco/internal/spigot/recipes/StackedRecipeListener\n*L\n45#1:156,2\n*E\n"})
public final class StackedRecipeListener
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EcoPlugin plugin;
    @NotNull
    private static final List<StackedRecipeHandler> handlers = new ArrayList();

    public StackedRecipeListener(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void handleStacks(@NotNull InventoryClickEvent event) {
        Object v3;
        CraftingRecipe recipe;
        CraftingInventory inventory;
        block13: {
            Intrinsics.checkNotNullParameter(event, "event");
            Inventory inventory2 = event.getClickedInventory();
            CraftingInventory craftingInventory = inventory2 instanceof CraftingInventory ? (CraftingInventory)inventory2 : null;
            if (craftingInventory == null) {
                return;
            }
            inventory = craftingInventory;
            if (event.getSlot() != 0) {
                return;
            }
            if (ItemsExtensions.isEcoEmpty(inventory.getItem(event.getSlot()))) {
                return;
            }
            ItemStack[] itemStackArray = inventory.getMatrix();
            Intrinsics.checkNotNullExpressionValue(itemStackArray, "getMatrix(...)");
            ItemStack[] matrix = itemStackArray;
            CraftingRecipe craftingRecipe = Recipes.getMatch(matrix);
            if (craftingRecipe == null) {
                return;
            }
            recipe = craftingRecipe;
            Iterable $this$firstOrNull$iv = handlers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                StackedRecipeHandler it = (StackedRecipeHandler)element$iv;
                boolean bl = false;
                if (!recipe.getClass().isAssignableFrom(it.getRecipeType())) continue;
                v3 = element$iv;
                break block13;
            }
            v3 = null;
        }
        StackedRecipeHandler stackedRecipeHandler = v3;
        if (stackedRecipeHandler == null) {
            return;
        }
        StackedRecipeHandler handler = stackedRecipeHandler;
        boolean isStackedRecipe = false;
        int maxCraftable = Integer.MAX_VALUE;
        Object maxToCraftData = handler.makeData(recipe);
        for (int i = 0; i < 9; ++i) {
            ItemStack item;
            ItemStack[] itemStackArray = inventory.getMatrix();
            Intrinsics.checkNotNullExpressionValue(itemStackArray, "getMatrix(...)");
            if ((ItemStack)ArraysKt.getOrNull((Object[])itemStackArray, i) == null) continue;
            TestableItem it = handler.getPart(recipe, i, item, maxToCraftData);
            boolean bl = false;
            TestableItem testableItem = it instanceof GroupedTestableItems ? ((GroupedTestableItems)it).getMatchingChild(item) : it;
            if (testableItem == null) continue;
            TestableItem part = testableItem;
            if (part instanceof TestableStack) {
                isStackedRecipe = true;
            }
            maxCraftable = Math.min(maxCraftable, Math.floorDiv(item.getAmount(), part.getItem().getAmount()));
        }
        if (!isStackedRecipe) {
            return;
        }
        maxCraftable = Math.min(maxCraftable, Math.floorDiv(recipe.getOutput().getMaxStackSize(), recipe.getOutput().getAmount()));
        ItemStack existingResult = inventory.getResult();
        Object deductionData = handler.makeData(recipe);
        for (int i = 0; i < 9; ++i) {
            TestableItem part;
            ItemStack item;
            ItemStack[] itemStackArray = inventory.getMatrix();
            Intrinsics.checkNotNullExpressionValue(itemStackArray, "getMatrix(...)");
            if ((ItemStack)ArraysKt.getOrNull((Object[])itemStackArray, i) == null) continue;
            TestableItem it = handler.getPart(recipe, i, item, deductionData);
            boolean bl = false;
            if ((it instanceof GroupedTestableItems ? ((GroupedTestableItems)it).getMatchingChild(item) : it) == null) continue;
            part = part;
            int amount = Math.max(event.isShiftClick() ? item.getAmount() - part.getItem().getAmount() * maxCraftable : item.getAmount() - part.getItem().getAmount(), 0);
            if (amount == 0) {
                item.setType(Material.AIR);
            }
            item.setAmount(amount);
            inventory.getMatrix()[i] = item.clone();
            this.runTwice(new Function0<Unit>(item, inventory, i, amount){
                final /* synthetic */ ItemStack $item;
                final /* synthetic */ CraftingInventory $inventory;
                final /* synthetic */ int $i;
                final /* synthetic */ int $amount;
                {
                    this.$item = $item;
                    this.$inventory = $inventory;
                    this.$i = $i;
                    this.$amount = $amount;
                    super(0);
                }

                public final void invoke() {
                    ItemStack newItem;
                    ItemStack itemStack = this.$item.clone();
                    Intrinsics.checkNotNullExpressionValue(itemStack, "clone(...)");
                    this.$inventory.getMatrix()[this.$i] = newItem = itemStack;
                    this.$inventory.setItem(this.$i + 1, newItem);
                    if (this.$inventory.getMatrix()[this.$i] != null) {
                        ItemStack itemStack2 = this.$inventory.getMatrix()[this.$i];
                        if (itemStack2 != null) {
                            itemStack2.setAmount(this.$amount);
                        }
                    }
                }
            });
        }
        if (existingResult == null) {
            return;
        }
        if (event.isShiftClick()) {
            existingResult.setAmount(existingResult.getAmount() * maxCraftable);
        }
        inventory.setResult(existingResult);
    }

    private final void runTwice(Function0<Unit> block) {
        block.invoke();
        this.plugin.getScheduler().run(() -> StackedRecipeListener.runTwice$lambda$3(block));
    }

    private static final void runTwice$lambda$3(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/internal/spigot/recipes/StackedRecipeListener$Companion;", "", "()V", "handlers", "", "Lcom/willfp/eco/internal/spigot/recipes/StackedRecipeHandler;", "registerHandler", "", "handler", "core-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerHandler(@NotNull StackedRecipeHandler handler) {
            Intrinsics.checkNotNullParameter(handler, "handler");
            handlers.add(handler);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

