/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.codecs;

import com.willfp.eco.libs.bson.BsonReader;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.Document;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.types.CodeWithScope;

public class CodeWithScopeCodec
implements Codec<CodeWithScope> {
    private final Codec<Document> documentCodec;

    public CodeWithScopeCodec(Codec<Document> documentCodec) {
        this.documentCodec = documentCodec;
    }

    @Override
    public CodeWithScope decode(BsonReader bsonReader, DecoderContext decoderContext) {
        String code = bsonReader.readJavaScriptWithScope();
        Document scope2 = (Document)this.documentCodec.decode(bsonReader, decoderContext);
        return new CodeWithScope(code, scope2);
    }

    @Override
    public void encode(BsonWriter writer, CodeWithScope codeWithScope, EncoderContext encoderContext) {
        writer.writeJavaScriptWithScope(codeWithScope.getCode());
        this.documentCodec.encode(writer, codeWithScope.getScope(), encoderContext);
    }

    @Override
    public Class<CodeWithScope> getEncoderClass() {
        return CodeWithScope.class;
    }
}

