/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.codecs;

import com.willfp.eco.libs.bson.BsonReader;
import com.willfp.eco.libs.bson.BsonType;
import com.willfp.eco.libs.bson.Transformer;
import com.willfp.eco.libs.bson.UuidRepresentation;
import com.willfp.eco.libs.bson.codecs.BsonTypeCodecMap;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.configuration.CodecConfigurationException;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.UUID;

final class ContainerCodecHelper {
    static Object readValue(BsonReader reader, DecoderContext decoderContext, BsonTypeCodecMap bsonTypeCodecMap, UuidRepresentation uuidRepresentation, CodecRegistry registry, Transformer valueTransformer) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        Codec<Object> codec = bsonTypeCodecMap.get(bsonType);
        if (bsonType == BsonType.BINARY && reader.peekBinarySize() == 16) {
            switch (reader.peekBinarySubType()) {
                case 3: {
                    if (uuidRepresentation != UuidRepresentation.JAVA_LEGACY && uuidRepresentation != UuidRepresentation.C_SHARP_LEGACY && uuidRepresentation != UuidRepresentation.PYTHON_LEGACY) break;
                    codec = registry.get(UUID.class);
                    break;
                }
                case 4: {
                    if (uuidRepresentation != UuidRepresentation.STANDARD) break;
                    codec = registry.get(UUID.class);
                    break;
                }
            }
        }
        return valueTransformer.transform(codec.decode(reader, decoderContext));
    }

    static Codec<?> getCodec(CodecRegistry codecRegistry, Type type2) {
        if (type2 instanceof Class) {
            return codecRegistry.get((Class)type2);
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            return codecRegistry.get((Class)parameterizedType.getRawType(), Arrays.asList(parameterizedType.getActualTypeArguments()));
        }
        throw new CodecConfigurationException("Unsupported generic type of container: " + type2);
    }

    private ContainerCodecHelper() {
    }
}

