/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.codecs.pojo;

import com.willfp.eco.libs.bson.codecs.pojo.ClassModelBuilder;
import com.willfp.eco.libs.bson.codecs.pojo.IdPropertyModelHolder;
import com.willfp.eco.libs.bson.codecs.pojo.InstanceCreator;
import com.willfp.eco.libs.bson.codecs.pojo.InstanceCreatorFactory;
import com.willfp.eco.libs.bson.codecs.pojo.PropertyModel;
import com.willfp.eco.libs.bson.codecs.pojo.TypeParameterMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ClassModel<T> {
    private final String name;
    private final Class<T> type;
    private final boolean hasTypeParameters;
    private final InstanceCreatorFactory<T> instanceCreatorFactory;
    private final boolean discriminatorEnabled;
    private final String discriminatorKey;
    private final String discriminator;
    private final IdPropertyModelHolder<?> idPropertyModelHolder;
    private final List<PropertyModel<?>> propertyModels;
    private final Map<String, TypeParameterMap> propertyNameToTypeParameterMap;

    ClassModel(Class<T> clazz, Map<String, TypeParameterMap> propertyNameToTypeParameterMap, InstanceCreatorFactory<T> instanceCreatorFactory, Boolean discriminatorEnabled, String discriminatorKey, String discriminator, IdPropertyModelHolder<?> idPropertyModelHolder, List<PropertyModel<?>> propertyModels) {
        this.name = clazz.getSimpleName();
        this.type = clazz;
        this.hasTypeParameters = clazz.getTypeParameters().length > 0;
        this.propertyNameToTypeParameterMap = Collections.unmodifiableMap(new HashMap<String, TypeParameterMap>(propertyNameToTypeParameterMap));
        this.instanceCreatorFactory = instanceCreatorFactory;
        this.discriminatorEnabled = discriminatorEnabled;
        this.discriminatorKey = discriminatorKey;
        this.discriminator = discriminator;
        this.idPropertyModelHolder = idPropertyModelHolder;
        this.propertyModels = Collections.unmodifiableList(new ArrayList(propertyModels));
    }

    public static <S> ClassModelBuilder<S> builder(Class<S> type2) {
        return new ClassModelBuilder<S>(type2);
    }

    InstanceCreator<T> getInstanceCreator() {
        return this.instanceCreatorFactory.create();
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean hasTypeParameters() {
        return this.hasTypeParameters;
    }

    public boolean useDiscriminator() {
        return this.discriminatorEnabled;
    }

    public String getDiscriminatorKey() {
        return this.discriminatorKey;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public PropertyModel<?> getPropertyModel(String propertyName) {
        for (PropertyModel<?> propertyModel : this.propertyModels) {
            if (!propertyModel.getName().equals(propertyName)) continue;
            return propertyModel;
        }
        return null;
    }

    public List<PropertyModel<?>> getPropertyModels() {
        return this.propertyModels;
    }

    public PropertyModel<?> getIdPropertyModel() {
        return this.idPropertyModelHolder != null ? this.idPropertyModelHolder.getPropertyModel() : null;
    }

    IdPropertyModelHolder<?> getIdPropertyModelHolder() {
        return this.idPropertyModelHolder;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ClassModel{type=" + this.type + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassModel that = (ClassModel)o;
        if (this.discriminatorEnabled != that.discriminatorEnabled) {
            return false;
        }
        if (!this.getType().equals(that.getType())) {
            return false;
        }
        if (!this.getInstanceCreatorFactory().equals(that.getInstanceCreatorFactory())) {
            return false;
        }
        if (this.getDiscriminatorKey() != null ? !this.getDiscriminatorKey().equals(that.getDiscriminatorKey()) : that.getDiscriminatorKey() != null) {
            return false;
        }
        if (this.getDiscriminator() != null ? !this.getDiscriminator().equals(that.getDiscriminator()) : that.getDiscriminator() != null) {
            return false;
        }
        if (!Objects.equals(this.idPropertyModelHolder, that.idPropertyModelHolder)) {
            return false;
        }
        if (!this.getPropertyModels().equals(that.getPropertyModels())) {
            return false;
        }
        return this.getPropertyNameToTypeParameterMap().equals(that.getPropertyNameToTypeParameterMap());
    }

    public int hashCode() {
        int result2 = this.getType().hashCode();
        result2 = 31 * result2 + this.getInstanceCreatorFactory().hashCode();
        result2 = 31 * result2 + (this.discriminatorEnabled ? 1 : 0);
        result2 = 31 * result2 + (this.getDiscriminatorKey() != null ? this.getDiscriminatorKey().hashCode() : 0);
        result2 = 31 * result2 + (this.getDiscriminator() != null ? this.getDiscriminator().hashCode() : 0);
        result2 = 31 * result2 + (this.getIdPropertyModelHolder() != null ? this.getIdPropertyModelHolder().hashCode() : 0);
        result2 = 31 * result2 + this.getPropertyModels().hashCode();
        result2 = 31 * result2 + this.getPropertyNameToTypeParameterMap().hashCode();
        return result2;
    }

    InstanceCreatorFactory<T> getInstanceCreatorFactory() {
        return this.instanceCreatorFactory;
    }

    Map<String, TypeParameterMap> getPropertyNameToTypeParameterMap() {
        return this.propertyNameToTypeParameterMap;
    }
}

