/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson4jackson.deserializers;

import com.willfp.eco.libs.bson4jackson.BsonParser;
import com.willfp.eco.libs.jackson.core.JsonParser;
import com.willfp.eco.libs.jackson.core.JsonToken;
import com.willfp.eco.libs.jackson.databind.DeserializationContext;
import com.willfp.eco.libs.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class BsonCalendarDeserializer
extends JsonDeserializer<Calendar> {
    @Override
    public Calendar deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp instanceof BsonParser) {
            BsonParser bsonParser = (BsonParser)jp;
            if (bsonParser.getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || bsonParser.getCurrentBsonType() != 9) {
                throw ctxt.mappingException(Date.class);
            }
            Object obj = bsonParser.getEmbeddedObject();
            if (obj == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)obj);
            return cal;
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT && jp.getEmbeddedObject() instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)jp.getEmbeddedObject());
            return cal;
        }
        Date date = new Date(jp.getLongValue());
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }
}

