/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson4jackson.io;

import java.io.InputStream;

public class UnsafeByteArrayInputStream
extends InputStream {
    protected final byte[] _buf;
    protected int _pos;
    protected int _count;
    protected int _mark;

    public UnsafeByteArrayInputStream(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public UnsafeByteArrayInputStream(byte[] buf, int off, int len) {
        this._buf = buf;
        this._pos = off;
        this._count = Math.min(off + len, buf.length);
        this._mark = off;
    }

    @Override
    public int read() {
        return this._pos >= this._count ? -1 : this._buf[this._pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this._pos >= this._count) {
            return -1;
        }
        int avail = this._count - this._pos;
        int cnt = Math.min(len, avail);
        System.arraycopy(this._buf, this._pos, b, off, cnt);
        this._pos += cnt;
        return cnt;
    }

    @Override
    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        int avail = this._count - this._pos;
        if (avail <= 0) {
            return 0L;
        }
        if ((long)avail < n) {
            n = avail;
        }
        this._pos = (int)((long)this._pos + n);
        return n;
    }

    @Override
    public int available() {
        return this._count - this._pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this._mark = this._pos;
    }

    @Override
    public void reset() {
        this._pos = this._mark;
    }

    @Override
    public void close() {
    }
}

