/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson4jackson.serializers;

import com.willfp.eco.libs.bson4jackson.BsonGenerator;
import com.willfp.eco.libs.jackson.core.JsonGenerator;
import com.willfp.eco.libs.jackson.databind.JsonSerializer;
import com.willfp.eco.libs.jackson.databind.SerializerProvider;
import com.willfp.eco.libs.jackson.databind.ser.std.UUIDSerializer;
import java.io.IOException;
import java.util.UUID;

public class BsonUuidSerializer
extends JsonSerializer<UUID> {
    @Override
    public void serialize(UUID value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (gen instanceof BsonGenerator) {
            BsonGenerator bgen = (BsonGenerator)gen;
            bgen.writeBinary(null, (byte)3, BsonUuidSerializer.uuidToLittleEndianBytes(value), 0, 16);
        } else {
            new UUIDSerializer().serialize(value, gen, provider);
        }
    }

    protected static byte[] uuidToLittleEndianBytes(UUID uuid) {
        int i;
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * i);
        }
        for (i = 8; i < 16; ++i) {
            buffer[i] = (byte)(lsb >>> 8 * (i - 16));
        }
        return buffer;
    }
}

