/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.crunch;

import com.willfp.eco.libs.crunch.CompiledExpression;
import com.willfp.eco.libs.crunch.Variable;
import com.willfp.eco.libs.crunch.data.CharTree;
import com.willfp.eco.libs.crunch.data.FastNumberParsing;
import com.willfp.eco.libs.crunch.data.Pair;
import com.willfp.eco.libs.crunch.data.TokenList;
import com.willfp.eco.libs.crunch.exceptions.ExpressionCompilationException;
import com.willfp.eco.libs.crunch.functional.ArgumentList;
import com.willfp.eco.libs.crunch.functional.EvaluationEnvironment;
import com.willfp.eco.libs.crunch.functional.Function;
import com.willfp.eco.libs.crunch.functional.FunctionCall;
import com.willfp.eco.libs.crunch.token.LiteralValue;
import com.willfp.eco.libs.crunch.token.Operation;
import com.willfp.eco.libs.crunch.token.Operator;
import com.willfp.eco.libs.crunch.token.Token;
import com.willfp.eco.libs.crunch.token.TokenType;
import com.willfp.eco.libs.crunch.token.Value;
import java.util.ArrayList;

class ExpressionCompiler {
    private static final char VAR_CHAR = '$';

    ExpressionCompiler() {
    }

    static CompiledExpression compile(String expression, EvaluationEnvironment env) {
        if (expression == null || env == null) {
            throw new ExpressionCompilationException("Expression and environment may not be null");
        }
        CompiledExpression exp = new CompiledExpression();
        Value val = ExpressionCompiler.compileValue(expression, exp, env, 0, false).getFirst();
        exp.setValue(val);
        return exp;
    }

    private static Pair<Value, Integer> compileValue(String expression, CompiledExpression exp, EvaluationEnvironment env, int begin, boolean parenthetical) {
        int i;
        CharTree<Token> namedTokens = env.getNamedTokens();
        TokenList tokens = new TokenList();
        Pair<Token, Integer> firstOp = namedTokens.getFrom(expression, begin);
        boolean op = firstOp.getFirst() != null && firstOp.getFirst().getType() == TokenType.OPERATOR;
        boolean closed = false;
        int tokenStart = begin;
        char[] chars = expression.toCharArray();
        block5: for (i = begin; i < expression.length(); ++i) {
            char c = chars[i];
            switch (c) {
                case '(': {
                    if (tokens.size() > 0 && tokens.tail().token.getType() == TokenType.FUNCTION) {
                        Pair<ArgumentList, Integer> args2 = ExpressionCompiler.compileArgumentList(expression, exp, env, i + 1);
                        tokens.add(args2.getFirst());
                        tokenStart = i += args2.getSecond().intValue();
                        op = true;
                        continue block5;
                    }
                    if (!op && tokenStart != i) {
                        tokens.add(ExpressionCompiler.compileToken(expression, tokenStart, i, exp));
                    }
                    if (tokens.tail() != null && tokens.tail().token instanceof Value) {
                        tokens.add(Operator.MULTIPLY);
                    }
                    Pair<Value, Integer> inner = ExpressionCompiler.compileValue(expression, exp, env, i + 1, true);
                    tokens.add(inner.getFirst());
                    tokenStart = i += inner.getSecond() + 1;
                    op = true;
                    continue block5;
                }
                case ' ': {
                    if (!op && tokenStart != i) {
                        tokens.add(ExpressionCompiler.compileToken(expression, tokenStart, i, exp));
                        tokenStart = i + 1;
                        continue block5;
                    }
                    ++tokenStart;
                    continue block5;
                }
                case ')': 
                case ',': {
                    if (!parenthetical) {
                        throw new ExpressionCompilationException("Unbalanced parenthesis");
                    }
                    closed = true;
                    break block5;
                }
                default: {
                    Pair<Token, Integer> namedToken = namedTokens.getFrom(expression, i);
                    if (namedToken.getFirst() != null) {
                        Token token2 = namedToken.getFirst();
                        if (token2.getType() == TokenType.VARIABLE) {
                            Variable var = ((Variable)token2).getClone();
                            var.expression = exp;
                            token2 = var;
                        }
                        if (!op && tokenStart != i) {
                            tokens.add(ExpressionCompiler.compileToken(expression, tokenStart, i, exp));
                        }
                        if ((token2.getType() != TokenType.OPERATOR || ((Operator)token2).isUnary()) && tokens.tail() != null && tokens.tail().token instanceof Value) {
                            tokens.add(Operator.MULTIPLY);
                        }
                        if (!(token2 != Operator.SUBTRACT || tokens.size() != 0 && tokens.tail().token instanceof Value)) {
                            token2 = Operator.NEGATE;
                        }
                        op = token2.getType() == TokenType.OPERATOR;
                        tokenStart = (i += namedToken.getSecond() - 1) + 1;
                        tokens.add(token2);
                        continue block5;
                    }
                    op = false;
                }
            }
        }
        if (parenthetical && !closed) {
            throw new ExpressionCompilationException("Unbalanced parenthesis");
        }
        if (tokenStart < i && i <= expression.length() && !op) {
            tokens.add(ExpressionCompiler.compileToken(expression, tokenStart, i, exp));
        }
        return new Pair<Value, Integer>(ExpressionCompiler.reduceTokens(tokens), i - begin);
    }

    private static Pair<ArgumentList, Integer> compileArgumentList(String expression, CompiledExpression exp, EvaluationEnvironment env, int start) {
        ArrayList<Value> values2 = new ArrayList<Value>();
        int i = start;
        block4: while (i < expression.length() && expression.charAt(i) != ')') {
            Pair<Value, Integer> result2 = ExpressionCompiler.compileValue(expression, exp, env, i, true);
            values2.add(result2.getFirst());
            switch (expression.charAt((i += result2.getSecond() + 1) - 1)) {
                case ')': {
                    break block4;
                }
                case ',': {
                    break;
                }
                default: {
                    throw new ExpressionCompilationException("Function argument lists must be separated by commas");
                }
            }
        }
        if (values2.size() == 0) {
            ++i;
        }
        if (expression.charAt(i - 1) != ')') {
            throw new ExpressionCompilationException("Unbalanced parenthesis");
        }
        Value[] valueArray = values2.toArray(new Value[values2.size()]);
        return new Pair<ArgumentList, Integer>(new ArgumentList(valueArray), i - start);
    }

    private static Value reduceTokens(TokenList tokens) {
        OperatorList[] priorities = new OperatorList[11];
        TokenList.Node node = tokens.head();
        while (node != null) {
            Token token2 = node.token;
            if (token2.getType() == TokenType.FUNCTION) {
                ExpressionCompiler.createFunctionCall(node);
            } else if (token2.getType() == TokenType.OPERATOR) {
                Operator op = (Operator)token2;
                OperatorList ops = priorities[op.getPriority()];
                if (ops == null) {
                    priorities[op.getPriority()] = ops = new OperatorList();
                }
                ops.add(node);
            }
            node = node.next;
        }
        for (int i = priorities.length - 1; i >= 0; --i) {
            OperatorList list = priorities[i];
            if (list == null) continue;
            list.forEach(ExpressionCompiler::createOperation);
        }
        Token token3 = tokens.head().token;
        if (!(token3 instanceof Value)) {
            throw new ExpressionCompilationException("Token is not a value: " + token3.toString());
        }
        if (tokens.size() > 1) {
            throw new ExpressionCompilationException("Adjacent values have no operators between them");
        }
        return (Value)tokens.head().token;
    }

    private static void createFunctionCall(TokenList.Node node) {
        if (node.next == null) {
            throw new ExpressionCompilationException("Function must be followed by argument list");
        }
        Token next = node.next.token;
        if (next.getType() != TokenType.ARGUMENT_LIST) {
            throw new ExpressionCompilationException("Function must be followed by argument list");
        }
        Function func = (Function)node.token;
        ArgumentList list = (ArgumentList)next;
        if (list.getArguments().length != func.getArgCount()) {
            throw new ExpressionCompilationException("Function '" + func.getName() + "' takes " + func.getArgCount() + " args, but got " + list.getArguments().length);
        }
        node.removeAfter();
        node.token = new FunctionCall(func, list.getArguments());
    }

    private static void createOperation(TokenList.Node node) {
        Operator op = (Operator)node.token;
        if (node.next == null) {
            throw new ExpressionCompilationException("Operator " + op + " has no following operand");
        }
        if (op.isUnary()) {
            Token next = node.next.token;
            node.removeAfter();
            if (next.getType() == TokenType.OPERATOR) {
                throw new ExpressionCompilationException("Adjacent operators have no values to operate on");
            }
            if (next.getType() == TokenType.LITERAL_VALUE) {
                Value literal = (Value)next;
                node.token = new LiteralValue(op.operate(literal.getValue()));
                return;
            }
            node.token = new Operation(op, (Value)next);
            return;
        }
        if (node.prev == null) {
            throw new ExpressionCompilationException("Operator " + op + " has no leading operand");
        }
        Token next = node.next.token;
        node.removeAfter();
        Token prev = node.prev.token;
        node.removeBefore();
        if (prev.getType() == TokenType.OPERATOR || next.getType() == TokenType.OPERATOR) {
            throw new ExpressionCompilationException("Adjacent operators have no values to operate on");
        }
        if (prev.getType() == TokenType.LITERAL_VALUE && next.getType() == TokenType.LITERAL_VALUE) {
            Value lit1 = (Value)prev;
            Value lit2 = (Value)next;
            node.token = new LiteralValue(op.operate(lit1.getValue(), lit2.getValue()));
            return;
        }
        node.token = new Operation(op, (Value)prev, (Value)next);
    }

    private static Token compileToken(String str, int start, int end, CompiledExpression exp) {
        if (str.charAt(start) == '$') {
            return new Variable(exp, FastNumberParsing.parseInt(str, start + 1, end) - 1);
        }
        return new LiteralValue(FastNumberParsing.parseDouble(str, start, end));
    }

    private static class OperatorList
    extends ArrayList<TokenList.Node> {
        private OperatorList() {
        }
    }
}

