/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.jackson.databind.deser.std;

import com.willfp.eco.libs.jackson.annotation.JsonFormat;
import com.willfp.eco.libs.jackson.core.JsonParser;
import com.willfp.eco.libs.jackson.core.JsonToken;
import com.willfp.eco.libs.jackson.databind.BeanProperty;
import com.willfp.eco.libs.jackson.databind.DeserializationContext;
import com.willfp.eco.libs.jackson.databind.DeserializationFeature;
import com.willfp.eco.libs.jackson.databind.JavaType;
import com.willfp.eco.libs.jackson.databind.JsonDeserializer;
import com.willfp.eco.libs.jackson.databind.JsonMappingException;
import com.willfp.eco.libs.jackson.databind.annotation.JacksonStdImpl;
import com.willfp.eco.libs.jackson.databind.cfg.CoercionAction;
import com.willfp.eco.libs.jackson.databind.cfg.CoercionInputShape;
import com.willfp.eco.libs.jackson.databind.deser.ContextualDeserializer;
import com.willfp.eco.libs.jackson.databind.deser.NullValueProvider;
import com.willfp.eco.libs.jackson.databind.deser.ValueInstantiator;
import com.willfp.eco.libs.jackson.databind.deser.std.ContainerDeserializerBase;
import com.willfp.eco.libs.jackson.databind.introspect.AnnotatedWithParams;
import com.willfp.eco.libs.jackson.databind.jsontype.TypeDeserializer;
import com.willfp.eco.libs.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;

@JacksonStdImpl
public final class StringCollectionDeserializer
extends ContainerDeserializerBase<Collection<String>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JsonDeserializer<String> _valueDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final JsonDeserializer<Object> _delegateDeserializer;

    public StringCollectionDeserializer(JavaType collectionType, JsonDeserializer<?> valueDeser, ValueInstantiator valueInstantiator) {
        this(collectionType, valueInstantiator, null, valueDeser, valueDeser, null);
    }

    protected StringCollectionDeserializer(JavaType collectionType, ValueInstantiator valueInstantiator, JsonDeserializer<?> delegateDeser, JsonDeserializer<?> valueDeser, NullValueProvider nuller, Boolean unwrapSingle) {
        super(collectionType, nuller, unwrapSingle);
        this._valueDeserializer = valueDeser;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = delegateDeser;
    }

    protected StringCollectionDeserializer withResolved(JsonDeserializer<?> delegateDeser, JsonDeserializer<?> valueDeser, NullValueProvider nuller, Boolean unwrapSingle) {
        if (Objects.equals(this._unwrapSingle, unwrapSingle) && this._nullProvider == nuller && this._valueDeserializer == valueDeser && this._delegateDeserializer == delegateDeser) {
            return this;
        }
        return new StringCollectionDeserializer(this._containerType, this._valueInstantiator, delegateDeser, valueDeser, nuller, unwrapSingle);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._delegateDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> delegate = null;
        if (this._valueInstantiator != null) {
            JavaType delegateType;
            AnnotatedWithParams delegateCreator = this._valueInstantiator.getArrayDelegateCreator();
            if (delegateCreator != null) {
                delegateType = this._valueInstantiator.getArrayDelegateType(ctxt.getConfig());
                delegate = this.findDeserializer(ctxt, delegateType, property);
            } else {
                delegateCreator = this._valueInstantiator.getDelegateCreator();
                if (delegateCreator != null) {
                    delegateType = this._valueInstantiator.getDelegateType(ctxt.getConfig());
                    delegate = this.findDeserializer(ctxt, delegateType, property);
                }
            }
        }
        JsonDeserializer<Object> valueDeser = this._valueDeserializer;
        JavaType valueType = this._containerType.getContentType();
        if (valueDeser == null) {
            if ((valueDeser = this.findConvertingContentDeserializer(ctxt, property, valueDeser)) == null) {
                valueDeser = ctxt.findContextualValueDeserializer(valueType, property);
            }
        } else {
            valueDeser = ctxt.handleSecondaryContextualization(valueDeser, property, valueType);
        }
        Boolean unwrapSingle = this.findFormatFeature(ctxt, property, Collection.class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        NullValueProvider nuller = this.findContentNullProvider(ctxt, property, valueDeser);
        if (this.isDefaultDeserializer(valueDeser)) {
            valueDeser = null;
        }
        return this.withResolved(delegate, valueDeser, nuller, unwrapSingle);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        return deser;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public Collection<String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this._delegateDeserializer != null) {
            return (Collection)this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        Collection result2 = (Collection)this._valueInstantiator.createUsingDefault(ctxt);
        return this.deserialize(p, ctxt, result2);
    }

    @Override
    public Collection<String> deserialize(JsonParser p, DeserializationContext ctxt, Collection<String> result2) throws IOException {
        if (!p.isExpectedStartArrayToken()) {
            return this.handleNonArray(p, ctxt, result2);
        }
        if (this._valueDeserializer != null) {
            return this.deserializeUsingCustom(p, ctxt, result2, this._valueDeserializer);
        }
        try {
            while (true) {
                String value;
                if ((value = p.nextTextValue()) != null) {
                    result2.add(value);
                    continue;
                }
                JsonToken t2 = p.currentToken();
                if (t2 != JsonToken.END_ARRAY) {
                    if (t2 == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        value = (String)this._nullProvider.getNullValue(ctxt);
                    } else {
                        value = this._parseString(p, ctxt, this._nullProvider);
                    }
                    result2.add(value);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, result2, result2.size());
        }
        return result2;
    }

    private Collection<String> deserializeUsingCustom(JsonParser p, DeserializationContext ctxt, Collection<String> result2, JsonDeserializer<String> deser) throws IOException {
        try {
            while (true) {
                String value;
                if (p.nextTextValue() == null) {
                    JsonToken t2 = p.currentToken();
                    if (t2 == JsonToken.END_ARRAY) break;
                    if (t2 == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        value = (String)this._nullProvider.getNullValue(ctxt);
                    } else {
                        value = deser.deserialize(p, ctxt);
                    }
                } else {
                    value = deser.deserialize(p, ctxt);
                }
                result2.add(value);
            }
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, result2, result2.size());
        }
        return result2;
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(p, ctxt);
    }

    private final Collection<String> handleNonArray(JsonParser p, DeserializationContext ctxt, Collection<String> result2) throws IOException {
        String value;
        boolean canWrap;
        boolean bl = canWrap = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!canWrap) {
            if (p.hasToken(JsonToken.VALUE_STRING)) {
                return (Collection)this._deserializeFromString(p, ctxt);
            }
            return (Collection)ctxt.handleUnexpectedToken(this._containerType, p);
        }
        JsonDeserializer<String> valueDes = this._valueDeserializer;
        JsonToken t2 = p.currentToken();
        if (t2 == JsonToken.VALUE_NULL) {
            if (this._skipNullValues) {
                return result2;
            }
            value = (String)this._nullProvider.getNullValue(ctxt);
        } else {
            if (p.hasToken(JsonToken.VALUE_STRING)) {
                CoercionAction act;
                String textValue = p.getText();
                if (textValue.isEmpty()) {
                    CoercionAction act2 = ctxt.findCoercionAction(this.logicalType(), this.handledType(), CoercionInputShape.EmptyString);
                    if (act2 != CoercionAction.Fail) {
                        return (Collection)this._deserializeFromEmptyString(p, ctxt, act2, this.handledType(), "empty String (\"\")");
                    }
                } else if (StringCollectionDeserializer._isBlank(textValue) && (act = ctxt.findCoercionFromBlankString(this.logicalType(), this.handledType(), CoercionAction.Fail)) != CoercionAction.Fail) {
                    return (Collection)this._deserializeFromEmptyString(p, ctxt, act, this.handledType(), "blank String (all whitespace)");
                }
            }
            try {
                value = valueDes == null ? this._parseString(p, ctxt, this._nullProvider) : valueDes.deserialize(p, ctxt);
            }
            catch (Exception e) {
                throw JsonMappingException.wrapWithPath((Throwable)e, result2, result2.size());
            }
        }
        result2.add(value);
        return result2;
    }
}

