/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.jackson.databind.ser.std;

import com.willfp.eco.libs.jackson.core.JsonGenerator;
import com.willfp.eco.libs.jackson.core.JsonToken;
import com.willfp.eco.libs.jackson.core.type.WritableTypeId;
import com.willfp.eco.libs.jackson.databind.JavaType;
import com.willfp.eco.libs.jackson.databind.JsonMappingException;
import com.willfp.eco.libs.jackson.databind.JsonNode;
import com.willfp.eco.libs.jackson.databind.SerializerProvider;
import com.willfp.eco.libs.jackson.databind.annotation.JacksonStdImpl;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.willfp.eco.libs.jackson.databind.jsontype.TypeSerializer;
import com.willfp.eco.libs.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ToEmptyObjectSerializer
extends StdSerializer<Object> {
    protected ToEmptyObjectSerializer(Class<?> raw) {
        super(raw, false);
    }

    public ToEmptyObjectSerializer(JavaType type2) {
        super(type2);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        gen.writeStartObject(value, 0);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        visitor2.expectObjectFormat(typeHint);
    }
}

