/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.jackson.databind.ser.std;

import com.willfp.eco.libs.jackson.core.JsonGenerator;
import com.willfp.eco.libs.jackson.core.JsonToken;
import com.willfp.eco.libs.jackson.core.type.WritableTypeId;
import com.willfp.eco.libs.jackson.databind.JavaType;
import com.willfp.eco.libs.jackson.databind.JsonMappingException;
import com.willfp.eco.libs.jackson.databind.JsonNode;
import com.willfp.eco.libs.jackson.databind.SerializerProvider;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.willfp.eco.libs.jackson.databind.jsontype.TypeSerializer;
import com.willfp.eco.libs.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public abstract class ToStringSerializerBase
extends StdSerializer<Object> {
    public ToStringSerializerBase(Class<?> handledType) {
        super(handledType, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        return this.valueToString(value).isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(this.valueToString(value));
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.VALUE_STRING));
        this.serialize(value, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor2, typeHint);
    }

    public abstract String valueToString(Object var1);
}

