/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.litote.kmongo.jackson;

import com.willfp.eco.libs.bson.types.ObjectId;
import com.willfp.eco.libs.jackson.core.JsonGenerator;
import com.willfp.eco.libs.jackson.core.JsonParser;
import com.willfp.eco.libs.jackson.core.JsonToken;
import com.willfp.eco.libs.jackson.databind.DeserializationContext;
import com.willfp.eco.libs.jackson.databind.JsonDeserializer;
import com.willfp.eco.libs.jackson.databind.JsonSerializer;
import com.willfp.eco.libs.jackson.databind.SerializerProvider;
import com.willfp.eco.libs.jackson.databind.module.SimpleModule;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.libs.mongodb.BasicDBObject;
import com.willfp.eco.libs.mongodb.DBObject;
import com.willfp.eco.libs.mongodb.DBRef;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/CustomJacksonModule;", "Lcom/willfp/eco/libs/jackson/databind/module/SimpleModule;", "()V", "kmongo-jackson-mapping"})
final class CustomJacksonModule
extends SimpleModule {
    @NotNull
    public static final CustomJacksonModule INSTANCE = new CustomJacksonModule();

    private CustomJacksonModule() {
    }

    static {
        INSTANCE.addSerializer(DBRef.class, new JsonSerializer<DBRef>(){

            @Override
            public void serialize(@Nullable DBRef value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
                Intrinsics.checkNotNullParameter(gen, "gen");
                Intrinsics.checkNotNullParameter(serializers, "serializers");
                if (value == null) {
                    gen.writeNull();
                } else {
                    Object id2;
                    gen.writeStartObject();
                    gen.writeStringField("$ref", value.getCollectionName());
                    gen.writeFieldName("$id");
                    Object object = id2 = value.getId();
                    if (object instanceof String) {
                        gen.writeString((String)id2);
                    } else if (object instanceof Long) {
                        Intrinsics.checkNotNullExpressionValue(id2, "id");
                        gen.writeNumber(((Number)id2).longValue());
                    } else if (object instanceof Integer) {
                        Intrinsics.checkNotNullExpressionValue(id2, "id");
                        gen.writeNumber(((Number)id2).intValue());
                    } else if (object instanceof Float) {
                        Intrinsics.checkNotNullExpressionValue(id2, "id");
                        gen.writeNumber(((Number)id2).floatValue());
                    } else if (object instanceof Double) {
                        Intrinsics.checkNotNullExpressionValue(id2, "id");
                        gen.writeNumber(((Number)id2).doubleValue());
                    } else if (object instanceof BigInteger) {
                        gen.writeNumber((BigInteger)id2);
                    } else if (object instanceof BigDecimal) {
                        gen.writeNumber((BigDecimal)id2);
                    } else if (object instanceof ObjectId) {
                        gen.writeObjectId(id2);
                    } else {
                        throw new IllegalStateException(("dbRef with id " + id2 + " of type " + id2.getClass() + " is not supported").toString());
                    }
                    if (value.getDatabaseName() != null) {
                        gen.writeStringField("$db", value.getDatabaseName());
                    }
                    gen.writeEndObject();
                }
            }
        });
        INSTANCE.addDeserializer(DBRef.class, (JsonDeserializer)new JsonDeserializer<DBRef>(){

            @Override
            @Nullable
            public DBRef deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
                DBRef dBRef;
                Intrinsics.checkNotNullParameter(jp, "jp");
                Intrinsics.checkNotNullParameter(ctxt, "ctxt");
                if (jp.isExpectedStartObjectToken()) {
                    Object object;
                    jp.nextValue();
                    String ref = jp.getValueAsString();
                    jp.nextValue();
                    JsonToken jsonToken = jp.getCurrentToken();
                    switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                        case 1: {
                            object = jp.getEmbeddedObject();
                            break;
                        }
                        case 2: {
                            object = jp.getValueAsString();
                            break;
                        }
                        default: {
                            object = jp.getDecimalValue();
                        }
                    }
                    Object id2 = object;
                    String db = null;
                    while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                        if (Intrinsics.areEqual(jp.getCurrentName(), "$db")) {
                            db = jp.getValueAsString();
                        }
                        jp.nextToken();
                    }
                    dBRef = new DBRef(db, ref, id2);
                } else {
                    dBRef = null;
                }
                return dBRef;
            }

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[JsonToken.values().length];
                    try {
                        nArray[JsonToken.VALUE_EMBEDDED_OBJECT.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[JsonToken.VALUE_STRING.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        });
        try {
            INSTANCE.addSerializer(DBObject.class, new JsonSerializer<DBObject>(){

                @Override
                public void serialize(@NotNull DBObject value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
                    Intrinsics.checkNotNullParameter(value, "value");
                    Intrinsics.checkNotNullParameter(gen, "gen");
                    Intrinsics.checkNotNullParameter(serializers, "serializers");
                    Map map2 = value.toMap();
                    serializers.findTypedValueSerializer(map2.getClass(), true, null).serialize(map2, gen, serializers);
                }
            }).addDeserializer(DBObject.class, (JsonDeserializer)new JsonDeserializer<DBObject>(){

                @Override
                @NotNull
                public DBObject deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
                    Intrinsics.checkNotNullParameter(jp, "jp");
                    Intrinsics.checkNotNullParameter(ctxt, "ctxt");
                    Map map2 = jp.readValueAs(Map.class);
                    return new BasicDBObject(map2);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

