/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb;

import com.willfp.eco.libs.bson.BsonArray;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonInt32;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.codecs.BsonDocumentCodec;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.json.JsonWriter;
import com.willfp.eco.libs.mongodb.MongoInternalException;
import com.willfp.eco.libs.mongodb.MongoServerException;
import com.willfp.eco.libs.mongodb.ServerAddress;
import java.io.StringWriter;

public class MongoCommandException
extends MongoServerException {
    private static final long serialVersionUID = 8160676451944215078L;
    private final BsonDocument response;

    public MongoCommandException(BsonDocument response, ServerAddress address) {
        super(MongoCommandException.extractErrorCode(response), MongoCommandException.extractErrorCodeName(response), String.format("Command failed with error %s: '%s' on server %s. The full response is %s", MongoCommandException.extractErrorCodeAndName(response), MongoCommandException.extractErrorMessage(response), address, MongoCommandException.getResponseAsJson(response)), address);
        this.response = response;
        this.addLabels(response.getArray("errorLabels", new BsonArray()));
    }

    public int getErrorCode() {
        return this.getCode();
    }

    @Override
    public String getErrorCodeName() {
        return super.getErrorCodeName();
    }

    public String getErrorMessage() {
        return MongoCommandException.extractErrorMessage(this.response);
    }

    public BsonDocument getResponse() {
        return this.response;
    }

    private static String getResponseAsJson(BsonDocument commandResponse) {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter(writer);
        new BsonDocumentCodec().encode((BsonWriter)jsonWriter, commandResponse, EncoderContext.builder().build());
        return writer.toString();
    }

    private static String extractErrorCodeAndName(BsonDocument response) {
        int errorCode = MongoCommandException.extractErrorCode(response);
        String errorCodeName = MongoCommandException.extractErrorCodeName(response);
        if (errorCodeName.isEmpty()) {
            return Integer.toString(errorCode);
        }
        return String.format("%d (%s)", errorCode, errorCodeName);
    }

    private static int extractErrorCode(BsonDocument response) {
        return response.getNumber("code", new BsonInt32(-1)).intValue();
    }

    private static String extractErrorCodeName(BsonDocument response) {
        return response.getString("codeName", new BsonString("")).getValue();
    }

    private static String extractErrorMessage(BsonDocument response) {
        String errorMessage2 = response.getString("errmsg", new BsonString("")).getValue();
        if (errorMessage2 == null) {
            throw new MongoInternalException("This value should not be null");
        }
        return errorMessage2;
    }
}

