/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonInt32;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.mongodb.MongoServerException;
import com.willfp.eco.libs.mongodb.ServerAddress;
import com.willfp.eco.libs.mongodb.WriteConcernResult;
import com.willfp.eco.libs.mongodb.lang.Nullable;

public class WriteConcernException
extends MongoServerException {
    private static final long serialVersionUID = -1100801000476719450L;
    private final WriteConcernResult writeConcernResult;
    private final BsonDocument response;

    public WriteConcernException(BsonDocument response, ServerAddress address, WriteConcernResult writeConcernResult) {
        super(WriteConcernException.extractErrorCode(response), String.format("Write failed with error code %d and error message '%s'", WriteConcernException.extractErrorCode(response), WriteConcernException.extractErrorMessage(response)), address);
        this.response = response;
        this.writeConcernResult = writeConcernResult;
    }

    public static int extractErrorCode(BsonDocument response) {
        String errorMessage2 = WriteConcernException.extractErrorMessage(response);
        if (errorMessage2 != null) {
            if (response.containsKey("err") && errorMessage2.contains("E11000 duplicate key error")) {
                return 11000;
            }
            if (!response.containsKey("code") && response.containsKey("errObjects")) {
                for (BsonValue curErrorDocument : response.getArray("errObjects")) {
                    if (!errorMessage2.equals(WriteConcernException.extractErrorMessage(curErrorDocument.asDocument()))) continue;
                    return curErrorDocument.asDocument().getNumber("code").intValue();
                }
            }
        }
        return response.getNumber("code", new BsonInt32(-1)).intValue();
    }

    @Nullable
    public static String extractErrorMessage(BsonDocument response) {
        if (response.isString("err")) {
            return response.getString("err").getValue();
        }
        if (response.isString("errmsg")) {
            return response.getString("errmsg").getValue();
        }
        return null;
    }

    public WriteConcernResult getWriteConcernResult() {
        return this.writeConcernResult;
    }

    public int getErrorCode() {
        return WriteConcernException.extractErrorCode(this.response);
    }

    @Nullable
    public String getErrorMessage() {
        return WriteConcernException.extractErrorMessage(this.response);
    }

    public BsonDocument getResponse() {
        return this.response;
    }
}

