/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.client.model.densify;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonInt64;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.Document;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.annotations.Evolving;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.model.MongoTimeUnit;
import com.willfp.eco.libs.mongodb.client.model.densify.DateDensifyRange;
import com.willfp.eco.libs.mongodb.client.model.densify.DensifyConstructibleBson;
import com.willfp.eco.libs.mongodb.client.model.densify.NumberDensifyRange;
import java.time.Instant;
import java.util.Arrays;

@Evolving
public interface DensifyRange
extends Bson {
    public static NumberDensifyRange fullRangeWithStep(Number step) {
        return new DensifyConstructibleBson(new Document("bounds", "full").append("step", Assertions.notNull("step", step)));
    }

    public static NumberDensifyRange partitionRangeWithStep(Number step) {
        return new DensifyConstructibleBson(new Document("bounds", "partition").append("step", Assertions.notNull("step", step)));
    }

    public static NumberDensifyRange rangeWithStep(Number l, Number u, Number step) {
        Assertions.notNull("l", l);
        Assertions.notNull("u", u);
        Assertions.notNull("step", step);
        return new DensifyConstructibleBson(new Document("bounds", Arrays.asList(l, u)).append("step", Assertions.notNull("step", step)));
    }

    public static DateDensifyRange fullRangeWithStep(long step, MongoTimeUnit unit) {
        Assertions.notNull("unit", unit);
        return new DensifyConstructibleBson(new BsonDocument("bounds", new BsonString("full")).append("step", new BsonInt64(step)).append("unit", new BsonString(unit.value())));
    }

    public static DateDensifyRange partitionRangeWithStep(long step, MongoTimeUnit unit) {
        Assertions.notNull("unit", unit);
        return new DensifyConstructibleBson(new BsonDocument("bounds", new BsonString("partition")).append("step", new BsonInt64(step)).append("unit", new BsonString(unit.value())));
    }

    public static DateDensifyRange rangeWithStep(Instant l, Instant u, long step, MongoTimeUnit unit) {
        Assertions.notNull("l", l);
        Assertions.notNull("u", u);
        Assertions.notNull("unit", unit);
        return new DensifyConstructibleBson(new Document("bounds", Arrays.asList(l, u)).append("step", step).append("unit", unit.value()));
    }

    public static DensifyRange of(Bson range) {
        return new DensifyConstructibleBson(Assertions.notNull("range", range));
    }
}

