/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.connection;

import com.willfp.eco.libs.bson.types.ObjectId;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.Objects;

public final class ClusterId {
    private final String value;
    private final String description;

    public ClusterId() {
        this(null);
    }

    public ClusterId(@Nullable String description2) {
        this.value = new ObjectId().toHexString();
        this.description = description2;
    }

    ClusterId(String value, String description2) {
        this.value = Assertions.notNull("value", value);
        this.description = description2;
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterId clusterId = (ClusterId)o;
        if (!this.value.equals(clusterId.value)) {
            return false;
        }
        return Objects.equals(this.description, clusterId.description);
    }

    public int hashCode() {
        int result2 = this.value.hashCode();
        result2 = 31 * result2 + (this.description != null ? this.description.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "ClusterId{value='" + this.value + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

