/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.connection;

import com.willfp.eco.libs.mongodb.ServerAddress;
import com.willfp.eco.libs.mongodb.annotations.Immutable;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.ClusterId;

@Immutable
public final class ServerId {
    private final ClusterId clusterId;
    private final ServerAddress address;

    public ServerId(ClusterId clusterId, ServerAddress address) {
        this.clusterId = Assertions.notNull("clusterId", clusterId);
        this.address = Assertions.notNull("address", address);
    }

    public ClusterId getClusterId() {
        return this.clusterId;
    }

    public ServerAddress getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerId serverId = (ServerId)o;
        if (!this.address.equals(serverId.address)) {
            return false;
        }
        return this.clusterId.equals(serverId.clusterId);
    }

    public int hashCode() {
        int result2 = this.clusterId.hashCode();
        result2 = 31 * result2 + this.address.hashCode();
        return result2;
    }

    public String toString() {
        return "ServerId{clusterId=" + this.clusterId + ", address=" + this.address + '}';
    }
}

