/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.event;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.mongodb.RequestContext;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.ConnectionDescription;
import com.willfp.eco.libs.mongodb.event.CommandEvent;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public final class CommandSucceededEvent
extends CommandEvent {
    private final BsonDocument response;
    private final long elapsedTimeNanos;

    public CommandSucceededEvent(@Nullable RequestContext requestContext, long operationId, int requestId, ConnectionDescription connectionDescription, String commandName, BsonDocument response, long elapsedTimeNanos) {
        super(requestContext, operationId, requestId, connectionDescription, commandName);
        this.response = response;
        Assertions.isTrueArgument("elapsed time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
    }

    @Deprecated
    public CommandSucceededEvent(@Nullable RequestContext requestContext, int requestId, ConnectionDescription connectionDescription, String commandName, BsonDocument response, long elapsedTimeNanos) {
        this(requestContext, -1L, requestId, connectionDescription, commandName, response, elapsedTimeNanos);
    }

    @Deprecated
    public CommandSucceededEvent(int requestId, ConnectionDescription connectionDescription, String commandName, BsonDocument response, long elapsedTimeNanos) {
        this(null, requestId, connectionDescription, commandName, response, elapsedTimeNanos);
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public BsonDocument getResponse() {
        return this.response;
    }
}

