/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.event;

import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.ServerId;

public final class ConnectionCheckOutFailedEvent {
    private final ServerId serverId;
    private final long operationId;
    private final Reason reason;

    public ConnectionCheckOutFailedEvent(ServerId serverId, long operationId, Reason reason) {
        this.serverId = Assertions.notNull("serverId", serverId);
        this.operationId = operationId;
        this.reason = Assertions.notNull("reason", reason);
    }

    @Deprecated
    public ConnectionCheckOutFailedEvent(ServerId serverId, Reason reason) {
        this(serverId, -1L, reason);
    }

    public ServerId getServerId() {
        return this.serverId;
    }

    public long getOperationId() {
        return this.operationId;
    }

    public Reason getReason() {
        return this.reason;
    }

    public String toString() {
        return "ConnectionCheckOutFailedEvent{server=" + this.serverId.getAddress() + ", clusterId=" + this.serverId.getClusterId() + ", operationId=" + this.operationId + ", reason=" + (Object)((Object)this.reason) + '}';
    }

    public static enum Reason {
        POOL_CLOSED,
        TIMEOUT,
        CONNECTION_ERROR,
        UNKNOWN;

    }
}

