/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.binding;

import com.willfp.eco.libs.mongodb.ReadPreference;
import com.willfp.eco.libs.mongodb.RequestContext;
import com.willfp.eco.libs.mongodb.ServerAddress;
import com.willfp.eco.libs.mongodb.ServerApi;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.ServerDescription;
import com.willfp.eco.libs.mongodb.internal.binding.AbstractReferenceCounted;
import com.willfp.eco.libs.mongodb.internal.binding.ConnectionSource;
import com.willfp.eco.libs.mongodb.internal.binding.ReadWriteBinding;
import com.willfp.eco.libs.mongodb.internal.connection.Cluster;
import com.willfp.eco.libs.mongodb.internal.connection.Connection;
import com.willfp.eco.libs.mongodb.internal.connection.NoOpSessionContext;
import com.willfp.eco.libs.mongodb.internal.connection.OperationContext;
import com.willfp.eco.libs.mongodb.internal.connection.ServerTuple;
import com.willfp.eco.libs.mongodb.internal.selector.ServerAddressSelector;
import com.willfp.eco.libs.mongodb.internal.session.SessionContext;
import com.willfp.eco.libs.mongodb.lang.Nullable;

public class SingleServerBinding
extends AbstractReferenceCounted
implements ReadWriteBinding {
    private final Cluster cluster;
    private final ServerAddress serverAddress;
    @Nullable
    private final ServerApi serverApi;
    private final RequestContext requestContext;
    private final OperationContext operationContext;

    public SingleServerBinding(Cluster cluster, ServerAddress serverAddress, @Nullable ServerApi serverApi, RequestContext requestContext) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
        this.serverApi = serverApi;
        this.requestContext = Assertions.notNull("requestContext", requestContext);
        this.operationContext = new OperationContext();
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new SingleServerBindingConnectionSource();
    }

    @Override
    public ReadPreference getReadPreference() {
        return ReadPreference.primary();
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new SingleServerBindingConnectionSource();
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SessionContext getSessionContext() {
        return NoOpSessionContext.INSTANCE;
    }

    @Override
    @Nullable
    public ServerApi getServerApi() {
        return this.serverApi;
    }

    @Override
    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public SingleServerBinding retain() {
        super.retain();
        return this;
    }

    private final class SingleServerBindingConnectionSource
    extends AbstractReferenceCounted
    implements ConnectionSource {
        private final ServerDescription serverDescription;

        private SingleServerBindingConnectionSource() {
            SingleServerBinding.this.retain();
            ServerTuple serverTuple = SingleServerBinding.this.cluster.selectServer(new ServerAddressSelector(SingleServerBinding.this.serverAddress), SingleServerBinding.this.operationContext);
            this.serverDescription = serverTuple.getServerDescription();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public SessionContext getSessionContext() {
            return NoOpSessionContext.INSTANCE;
        }

        @Override
        public OperationContext getOperationContext() {
            return SingleServerBinding.this.operationContext;
        }

        @Override
        public ServerApi getServerApi() {
            return SingleServerBinding.this.serverApi;
        }

        @Override
        public RequestContext getRequestContext() {
            return SingleServerBinding.this.requestContext;
        }

        @Override
        public ReadPreference getReadPreference() {
            return ReadPreference.primary();
        }

        @Override
        public Connection getConnection() {
            return SingleServerBinding.this.cluster.selectServer(new ServerAddressSelector(SingleServerBinding.this.serverAddress), SingleServerBinding.this.operationContext).getServer().getConnection(SingleServerBinding.this.operationContext);
        }

        @Override
        public ConnectionSource retain() {
            super.retain();
            return this;
        }

        @Override
        public int release() {
            int count2 = super.release();
            if (count2 == 0) {
                SingleServerBinding.this.release();
            }
            return count2;
        }
    }
}

