/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.binding;

import com.willfp.eco.libs.mongodb.connection.ClusterType;
import com.willfp.eco.libs.mongodb.internal.binding.AbstractReferenceCounted;
import com.willfp.eco.libs.mongodb.internal.binding.ReferenceCounted;
import com.willfp.eco.libs.mongodb.internal.connection.Connection;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.session.ClientSession;
import java.util.function.BiConsumer;

public final class TransactionContext<C extends ReferenceCounted>
extends AbstractReferenceCounted {
    private final ClusterType clusterType;
    private C pinnedConnection;

    public TransactionContext(ClusterType clusterType) {
        this.clusterType = clusterType;
    }

    @Nullable
    public C getPinnedConnection() {
        return this.pinnedConnection;
    }

    public void pinConnection(C connection, BiConsumer<C, Connection.PinningMode> markAsPinnedOperation) {
        this.pinnedConnection = connection.retain();
        markAsPinnedOperation.accept(connection, Connection.PinningMode.TRANSACTION);
    }

    public boolean isConnectionPinningRequired() {
        return this.clusterType == ClusterType.LOAD_BALANCED;
    }

    @Override
    public int release() {
        int count2 = super.release();
        if (count2 == 0 && this.pinnedConnection != null) {
            this.pinnedConnection.release();
        }
        return count2;
    }

    @Nullable
    public static <C extends TransactionContext<? extends ReferenceCounted>> C get(ClientSession session) {
        return (C)((TransactionContext)session.getTransactionContext());
    }
}

