/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.connection;

import com.willfp.eco.libs.bson.BsonArray;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.mongodb.AuthenticationMechanism;
import com.willfp.eco.libs.mongodb.MongoException;
import com.willfp.eco.libs.mongodb.MongoSecurityException;
import com.willfp.eco.libs.mongodb.ServerApi;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.ClusterConnectionMode;
import com.willfp.eco.libs.mongodb.connection.ConnectionDescription;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.connection.Authenticator;
import com.willfp.eco.libs.mongodb.internal.connection.InternalConnection;
import com.willfp.eco.libs.mongodb.internal.connection.MongoCredentialWithCache;
import com.willfp.eco.libs.mongodb.internal.connection.ScramShaAuthenticator;
import com.willfp.eco.libs.mongodb.internal.connection.SpeculativeAuthenticator;
import com.willfp.eco.libs.mongodb.internal.operation.ServerVersionHelper;
import com.willfp.eco.libs.mongodb.lang.Nullable;

class DefaultAuthenticator
extends Authenticator
implements SpeculativeAuthenticator {
    static final int USER_NOT_FOUND_CODE = 11;
    private static final BsonString DEFAULT_MECHANISM_NAME = new BsonString(AuthenticationMechanism.SCRAM_SHA_256.getMechanismName());
    private Authenticator delegate;

    DefaultAuthenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
        Assertions.isTrueArgument("unspecified authentication mechanism", credential.getAuthenticationMechanism() == null);
    }

    @Override
    void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotZero(connectionDescription)) {
            new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(AuthenticationMechanism.SCRAM_SHA_1), this.getClusterConnectionMode(), this.getServerApi()).authenticate(connection, connectionDescription);
        } else {
            try {
                this.setDelegate(connectionDescription);
                this.delegate.authenticate(connection, connectionDescription);
            }
            catch (Exception e) {
                throw this.wrapException(e);
            }
        }
    }

    @Override
    void authenticateAsync(InternalConnection connection, ConnectionDescription connectionDescription, SingleResultCallback<Void> callback) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotZero(connectionDescription)) {
            new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(AuthenticationMechanism.SCRAM_SHA_1), this.getClusterConnectionMode(), this.getServerApi()).authenticateAsync(connection, connectionDescription, callback);
        } else {
            this.setDelegate(connectionDescription);
            this.delegate.authenticateAsync(connection, connectionDescription, callback);
        }
    }

    @Override
    public BsonDocument createSpeculativeAuthenticateCommand(InternalConnection connection) {
        this.delegate = this.getAuthenticatorForHello();
        return ((SpeculativeAuthenticator)((Object)this.delegate)).createSpeculativeAuthenticateCommand(connection);
    }

    @Override
    @Nullable
    public BsonDocument getSpeculativeAuthenticateResponse() {
        if (this.delegate != null) {
            return ((SpeculativeAuthenticator)((Object)this.delegate)).getSpeculativeAuthenticateResponse();
        }
        return null;
    }

    @Override
    public void setSpeculativeAuthenticateResponse(BsonDocument response) {
        ((SpeculativeAuthenticator)((Object)this.delegate)).setSpeculativeAuthenticateResponse(response);
    }

    Authenticator getAuthenticatorForHello() {
        return new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(AuthenticationMechanism.SCRAM_SHA_256), this.getClusterConnectionMode(), this.getServerApi());
    }

    private void setDelegate(ConnectionDescription connectionDescription) {
        if (this.delegate != null && ((SpeculativeAuthenticator)((Object)this.delegate)).getSpeculativeAuthenticateResponse() != null) {
            return;
        }
        if (connectionDescription.getSaslSupportedMechanisms() != null) {
            BsonArray saslSupportedMechs = connectionDescription.getSaslSupportedMechanisms();
            AuthenticationMechanism mechanism = saslSupportedMechs.contains(DEFAULT_MECHANISM_NAME) ? AuthenticationMechanism.SCRAM_SHA_256 : AuthenticationMechanism.SCRAM_SHA_1;
            this.delegate = new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(mechanism), this.getClusterConnectionMode(), this.getServerApi());
        } else {
            this.delegate = new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(AuthenticationMechanism.SCRAM_SHA_1), this.getClusterConnectionMode(), this.getServerApi());
        }
    }

    private MongoException wrapException(Throwable t2) {
        if (t2 instanceof MongoSecurityException) {
            return (MongoSecurityException)t2;
        }
        if (t2 instanceof MongoException && ((MongoException)t2).getCode() == 11) {
            return new MongoSecurityException(this.getMongoCredential(), String.format("Exception authenticating %s", this.getMongoCredential()), t2);
        }
        return Assertions.assertNotNull(MongoException.fromThrowable(t2));
    }
}

