/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.connection;

import com.willfp.eco.libs.bson.BsonArray;
import com.willfp.eco.libs.bson.BsonBoolean;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonInt32;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.types.ObjectId;
import com.willfp.eco.libs.mongodb.MongoClientException;
import com.willfp.eco.libs.mongodb.ServerAddress;
import com.willfp.eco.libs.mongodb.Tag;
import com.willfp.eco.libs.mongodb.TagSet;
import com.willfp.eco.libs.mongodb.connection.ClusterConnectionMode;
import com.willfp.eco.libs.mongodb.connection.ConnectionDescription;
import com.willfp.eco.libs.mongodb.connection.ConnectionId;
import com.willfp.eco.libs.mongodb.connection.ServerConnectionState;
import com.willfp.eco.libs.mongodb.connection.ServerDescription;
import com.willfp.eco.libs.mongodb.connection.ServerType;
import com.willfp.eco.libs.mongodb.connection.TopologyVersion;
import com.willfp.eco.libs.mongodb.internal.connection.CommandHelper;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class DescriptionHelper {
    static ConnectionDescription createConnectionDescription(ClusterConnectionMode clusterConnectionMode, ConnectionId connectionId, BsonDocument helloResult) {
        ConnectionDescription connectionDescription = new ConnectionDescription(connectionId, DescriptionHelper.getMaxWireVersion(helloResult), DescriptionHelper.getServerType(helloResult), DescriptionHelper.getMaxWriteBatchSize(helloResult), DescriptionHelper.getMaxBsonObjectSize(helloResult), DescriptionHelper.getMaxMessageSizeBytes(helloResult), DescriptionHelper.getCompressors(helloResult), helloResult.getArray("saslSupportedMechs", null), DescriptionHelper.getLogicalSessionTimeoutMinutes(helloResult));
        if (helloResult.containsKey("connectionId")) {
            ConnectionId newConnectionId = connectionDescription.getConnectionId().withServerValue(helloResult.getNumber("connectionId").intValue());
            connectionDescription = connectionDescription.withConnectionId(newConnectionId);
        }
        if (clusterConnectionMode == ClusterConnectionMode.LOAD_BALANCED) {
            ObjectId serviceId = DescriptionHelper.getServiceId(helloResult);
            if (serviceId != null) {
                connectionDescription = connectionDescription.withServiceId(serviceId);
            } else {
                throw new MongoClientException("Driver attempted to initialize in load balancing mode, but the server does not support this mode");
            }
        }
        return connectionDescription;
    }

    public static ServerDescription createServerDescription(ServerAddress serverAddress, BsonDocument helloResult, long roundTripTime) {
        return ServerDescription.builder().state(ServerConnectionState.CONNECTED).address(serverAddress).type(DescriptionHelper.getServerType(helloResult)).canonicalAddress(helloResult.containsKey("me") ? helloResult.getString("me").getValue() : null).hosts(DescriptionHelper.listToSet(helloResult.getArray("hosts", new BsonArray()))).passives(DescriptionHelper.listToSet(helloResult.getArray("passives", new BsonArray()))).arbiters(DescriptionHelper.listToSet(helloResult.getArray("arbiters", new BsonArray()))).primary(DescriptionHelper.getString(helloResult, "primary")).maxDocumentSize(DescriptionHelper.getMaxBsonObjectSize(helloResult)).tagSet(DescriptionHelper.getTagSetFromDocument(helloResult.getDocument("tags", new BsonDocument()))).setName(DescriptionHelper.getString(helloResult, "setName")).minWireVersion(DescriptionHelper.getMinWireVersion(helloResult)).maxWireVersion(DescriptionHelper.getMaxWireVersion(helloResult)).electionId(DescriptionHelper.getElectionId(helloResult)).setVersion(DescriptionHelper.getSetVersion(helloResult)).topologyVersion(DescriptionHelper.getTopologyVersion(helloResult)).lastWriteDate(DescriptionHelper.getLastWriteDate(helloResult)).roundTripTime(roundTripTime, TimeUnit.NANOSECONDS).logicalSessionTimeoutMinutes(DescriptionHelper.getLogicalSessionTimeoutMinutes(helloResult)).helloOk(helloResult.getBoolean("helloOk", BsonBoolean.FALSE).getValue()).ok(CommandHelper.isCommandOk(helloResult)).build();
    }

    private static int getMinWireVersion(BsonDocument helloResult) {
        return helloResult.getInt32("minWireVersion", new BsonInt32(ServerDescription.getDefaultMinWireVersion())).getValue();
    }

    private static int getMaxWireVersion(BsonDocument helloResult) {
        return helloResult.getInt32("maxWireVersion", new BsonInt32(ServerDescription.getDefaultMaxWireVersion())).getValue();
    }

    @Nullable
    private static Date getLastWriteDate(BsonDocument helloResult) {
        if (!helloResult.containsKey("lastWrite")) {
            return null;
        }
        return new Date(helloResult.getDocument("lastWrite").getDateTime("lastWriteDate").getValue());
    }

    @Nullable
    private static ObjectId getElectionId(BsonDocument helloResult) {
        return helloResult.containsKey("electionId") ? helloResult.getObjectId("electionId").getValue() : null;
    }

    @Nullable
    private static Integer getSetVersion(BsonDocument helloResult) {
        return helloResult.containsKey("setVersion") ? Integer.valueOf(helloResult.getNumber("setVersion").intValue()) : null;
    }

    @Nullable
    private static TopologyVersion getTopologyVersion(BsonDocument helloResult) {
        return helloResult.containsKey("topologyVersion") && helloResult.get("topologyVersion").isDocument() ? new TopologyVersion(helloResult.getDocument("topologyVersion")) : null;
    }

    @Nullable
    private static ObjectId getServiceId(BsonDocument helloResult) {
        return helloResult.containsKey("serviceId") && helloResult.get("serviceId").isObjectId() ? helloResult.getObjectId("serviceId").getValue() : null;
    }

    private static int getMaxMessageSizeBytes(BsonDocument helloResult) {
        return helloResult.getInt32("maxMessageSizeBytes", new BsonInt32(ConnectionDescription.getDefaultMaxMessageSize())).getValue();
    }

    private static int getMaxBsonObjectSize(BsonDocument helloResult) {
        return helloResult.getInt32("maxBsonObjectSize", new BsonInt32(ServerDescription.getDefaultMaxDocumentSize())).getValue();
    }

    private static int getMaxWriteBatchSize(BsonDocument helloResult) {
        return helloResult.getInt32("maxWriteBatchSize", new BsonInt32(ConnectionDescription.getDefaultMaxWriteBatchSize())).getValue();
    }

    @Nullable
    private static Integer getLogicalSessionTimeoutMinutes(BsonDocument helloResult) {
        return helloResult.isNumber("logicalSessionTimeoutMinutes") ? Integer.valueOf(helloResult.getNumber("logicalSessionTimeoutMinutes").intValue()) : null;
    }

    @Nullable
    private static String getString(BsonDocument response, String key) {
        if (response.containsKey(key)) {
            return response.getString(key).getValue();
        }
        return null;
    }

    private static Set<String> listToSet(@Nullable BsonArray array) {
        if (array == null || array.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (BsonValue value : array) {
            set.add(value.asString().getValue());
        }
        return set;
    }

    private static ServerType getServerType(BsonDocument helloResult) {
        if (!CommandHelper.isCommandOk(helloResult)) {
            return ServerType.UNKNOWN;
        }
        if (DescriptionHelper.isReplicaSetMember(helloResult)) {
            if (helloResult.getBoolean("hidden", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_OTHER;
            }
            if (helloResult.getBoolean("isWritablePrimary", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_PRIMARY;
            }
            if (helloResult.getBoolean(CommandHelper.LEGACY_HELLO_LOWER, BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_PRIMARY;
            }
            if (helloResult.getBoolean("secondary", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_SECONDARY;
            }
            if (helloResult.getBoolean("arbiterOnly", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_ARBITER;
            }
            if (helloResult.containsKey("setName") && helloResult.containsKey("hosts")) {
                return ServerType.REPLICA_SET_OTHER;
            }
            return ServerType.REPLICA_SET_GHOST;
        }
        if (helloResult.containsKey("msg") && helloResult.get("msg").equals(new BsonString("isdbgrid"))) {
            return ServerType.SHARD_ROUTER;
        }
        return ServerType.STANDALONE;
    }

    private static boolean isReplicaSetMember(BsonDocument helloResult) {
        return helloResult.containsKey("setName") || helloResult.getBoolean("isreplicaset", BsonBoolean.FALSE).getValue();
    }

    private static TagSet getTagSetFromDocument(BsonDocument tagsDocuments) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (Map.Entry<String, BsonValue> curEntry : tagsDocuments.entrySet()) {
            tagList.add(new Tag(curEntry.getKey(), curEntry.getValue().asString().getValue()));
        }
        return new TagSet(tagList);
    }

    private static List<String> getCompressors(BsonDocument helloResult) {
        ArrayList<String> compressorList = new ArrayList<String>();
        for (BsonValue compressor : helloResult.getArray("compression", new BsonArray())) {
            compressorList.add(compressor.asString().getValue());
        }
        return compressorList;
    }

    private DescriptionHelper() {
    }
}

