/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.connection;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.mongodb.LoggerSettings;
import com.willfp.eco.libs.mongodb.MongoCompressor;
import com.willfp.eco.libs.mongodb.MongoDriverInformation;
import com.willfp.eco.libs.mongodb.ServerApi;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.ClusterConnectionMode;
import com.willfp.eco.libs.mongodb.connection.ServerId;
import com.willfp.eco.libs.mongodb.connection.StreamFactory;
import com.willfp.eco.libs.mongodb.event.CommandListener;
import com.willfp.eco.libs.mongodb.internal.connection.Authenticator;
import com.willfp.eco.libs.mongodb.internal.connection.AwsAuthenticator;
import com.willfp.eco.libs.mongodb.internal.connection.ClientMetadataHelper;
import com.willfp.eco.libs.mongodb.internal.connection.ConnectionGenerationSupplier;
import com.willfp.eco.libs.mongodb.internal.connection.DefaultAuthenticator;
import com.willfp.eco.libs.mongodb.internal.connection.GSSAPIAuthenticator;
import com.willfp.eco.libs.mongodb.internal.connection.InternalConnection;
import com.willfp.eco.libs.mongodb.internal.connection.InternalConnectionFactory;
import com.willfp.eco.libs.mongodb.internal.connection.InternalStreamConnection;
import com.willfp.eco.libs.mongodb.internal.connection.InternalStreamConnectionInitializer;
import com.willfp.eco.libs.mongodb.internal.connection.MongoCredentialWithCache;
import com.willfp.eco.libs.mongodb.internal.connection.PlainAuthenticator;
import com.willfp.eco.libs.mongodb.internal.connection.ScramShaAuthenticator;
import com.willfp.eco.libs.mongodb.internal.connection.X509Authenticator;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.spi.dns.InetAddressResolver;
import java.util.List;

class InternalStreamConnectionFactory
implements InternalConnectionFactory {
    private final ClusterConnectionMode clusterConnectionMode;
    private final boolean isMonitoringConnection;
    private final StreamFactory streamFactory;
    private final BsonDocument clientMetadataDocument;
    private final List<MongoCompressor> compressorList;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    @Nullable
    private final ServerApi serverApi;
    private final InetAddressResolver inetAddressResolver;
    private final MongoCredentialWithCache credential;

    InternalStreamConnectionFactory(ClusterConnectionMode clusterConnectionMode, StreamFactory streamFactory, @Nullable MongoCredentialWithCache credential, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable ServerApi serverApi, @Nullable InetAddressResolver inetAddressResolver) {
        this(clusterConnectionMode, false, streamFactory, credential, applicationName, mongoDriverInformation, compressorList, loggerSettings, commandListener, serverApi, inetAddressResolver);
    }

    InternalStreamConnectionFactory(ClusterConnectionMode clusterConnectionMode, boolean isMonitoringConnection, StreamFactory streamFactory, @Nullable MongoCredentialWithCache credential, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable ServerApi serverApi, @Nullable InetAddressResolver inetAddressResolver) {
        this.clusterConnectionMode = clusterConnectionMode;
        this.isMonitoringConnection = isMonitoringConnection;
        this.streamFactory = Assertions.notNull("streamFactory", streamFactory);
        this.compressorList = Assertions.notNull("compressorList", compressorList);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.serverApi = serverApi;
        this.inetAddressResolver = inetAddressResolver;
        this.clientMetadataDocument = ClientMetadataHelper.createClientMetadataDocument(applicationName, mongoDriverInformation);
        this.credential = credential;
    }

    @Override
    public InternalConnection create(ServerId serverId, ConnectionGenerationSupplier connectionGenerationSupplier) {
        Authenticator authenticator = this.credential == null ? null : this.createAuthenticator(this.credential);
        return new InternalStreamConnection(this.clusterConnectionMode, this.isMonitoringConnection, serverId, connectionGenerationSupplier, this.streamFactory, this.compressorList, this.loggerSettings, this.commandListener, new InternalStreamConnectionInitializer(this.clusterConnectionMode, authenticator, this.clientMetadataDocument, this.compressorList, this.serverApi), this.inetAddressResolver);
    }

    private Authenticator createAuthenticator(MongoCredentialWithCache credential) {
        if (credential.getAuthenticationMechanism() == null) {
            return new DefaultAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
        }
        switch (Assertions.assertNotNull(credential.getAuthenticationMechanism())) {
            case GSSAPI: {
                return new GSSAPIAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case PLAIN: {
                return new PlainAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_X509: {
                return new X509Authenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case SCRAM_SHA_1: 
            case SCRAM_SHA_256: {
                return new ScramShaAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
            case MONGODB_AWS: {
                return new AwsAuthenticator(credential, this.clusterConnectionMode, this.serverApi);
            }
        }
        throw new IllegalArgumentException("Unsupported authentication mechanism " + (Object)((Object)credential.getAuthenticationMechanism()));
    }
}

